/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.web;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.util.HtmlUtils;

import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogTypeService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 犬只种类Controller
 * 
 * @author zhuoHeng
 * @version 2016-07-21
 */
@Controller
@RequestMapping(value = "${adminPath}/dogtype/dogType")
public class DogTypeController extends BaseController {

	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogColorMarkService dogColorMarkService;

	@ModelAttribute
	public DogType get(@RequestParam(required = false) String id) {
		DogType entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogTypeService.get(id);
		}
		if (entity == null) {
			entity = new DogType();
		}
		return entity;
	}

	@RequiresPermissions("dogtype:dogType:view")
	@RequestMapping(value = { "list", "" })
	public String list(DogType dogType, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogType> page = dogTypeService.findPage(new Page<DogType>(request, response), dogType);
		model.addAttribute("page", page);
		return "oa/dog/dogtype/dogTypeList";
	}

	@RequiresPermissions("dogtype:dogType:view")
	@RequestMapping(value = "form")
	public String form(DogType dogType, Model model) {
		model.addAttribute("dogType", dogType);
		return "oa/dog/dogtype/dogTypeForm";
	}

	/**
	 * 查看
	 * 
	 * @Author chaixueteng
	 * @2016年8月27日下午4:45:02
	 */
	@RequiresPermissions("dogtype:dogType:view")
	@RequestMapping(value = "view")
	public String view(DogType dogType, Model model) {
		model.addAttribute("dogType", dogType);
		// FCI犬种信息查询显示犬种毛色信息
		List<DogColorMark> dogColorMarkList = dogColorMarkService.findAllList();
		model.addAttribute("dogColorMarkList", dogColorMarkList);
		return "oa/dog/dogtype/dogTypeView";
	}

	/**
	 * 编辑
	 * 
	 * @Author chaixueteng
	 * @2016年8月27日下午4:45:02
	 */
	@RequiresPermissions("dogtype:dogType:edit")
	@RequestMapping(value = "edit")
	public String edit(DogType dogType, Model model) {
		model.addAttribute("dogType", dogType);
		// FCI犬种信息查询显示犬种毛色信息
		List<DogColorMark> dogColorMarkList = dogColorMarkService.findAllList();
		model.addAttribute("dogColorMarkList", dogColorMarkList);
		return "oa/dog/dogtype/dogTypeEdit";
	}

	/**
	 * 编辑
	 * 
	 * @Author chaixueteng
	 * @2016年8月27日下午4:45:02
	 */
	@RequiresPermissions("dogtype:dogType:editAlias")
	@RequestMapping(value = "editAlias")
	public String editAlias(DogType dogType, Model model) {
		model.addAttribute("dogType", dogType);
		// FCI犬种信息查询显示犬种毛色信息
		List<DogColorMark> dogColorMarkList = dogColorMarkService.findAllList();
		model.addAttribute("dogColorMarkList", dogColorMarkList);
		return "oa/dog/dogtype/dogTypeEditAlias";
	}

	@RequiresPermissions("dogtype:dogType:edit")
	@RequestMapping(value = "save")
	public String save(DogType dogType, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogType)) {
			return form(dogType, model);
		}
		dogType.setDogColor(HtmlUtils.htmlUnescape(dogType.getDogColor()));
		dogTypeService.save(dogType);
		addMessage(redirectAttributes, "保存犬只种类成功");
		return "redirect:" + Global.getAdminPath() + "/dogtype/dogType/?repage";
	}

	@RequiresPermissions("dogtype:dogType:editAlias")
	@RequestMapping(value = "saveAlias")
	public String saveAlias(DogType dogType, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogType)) {
			return form(dogType, model);
		}
		dogTypeService.save(dogType);
		addMessage(redirectAttributes, "保存犬只种类成功");
		return "redirect:" + Global.getAdminPath() + "/dogtype/dogType/?repage";
	}

	@RequiresPermissions("dogtype:dogType:edit")
	@RequestMapping(value = "delete")
	public String delete(DogType dogType, RedirectAttributes redirectAttributes) {
		dogTypeService.delete(dogType);
		addMessage(redirectAttributes, "删除犬只种类成功");
		return "redirect:" + Global.getAdminPath() + "/dogtype/dogType/?repage";
	}

	/**
	 * 犬种代码唯一性
	 * 
	 * @Author chaixueteng
	 * @2016年9月18日下午3:34:16
	 */
	@RequestMapping(value = "dogBreedCodeCheck")
	@ResponseBody
	public String dogBreedCodeCheck(HttpServletRequest request, HttpServletResponse response) {
		String dogBreedCode = request.getParameter("dogBreedCode");
		String id = request.getParameter("id");
		return dogTypeService.dogBreedCodeCheck(dogBreedCode, id);
	}

	@RequestMapping(value = "type/list")
	@ResponseBody
	public List<DogType> api_list(HttpServletResponse response, HttpServletRequest request) throws IOException {
		List<DogType> lp = dogTypeService.findList(new DogType());
		return lp;
	}
}