package com.cku.oa.dog.service;

import java.util.Date;
import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogTibetanMastiffDao;
import com.cku.oa.dog.entity.DogTibetanMastiff;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 藏獒犬只鉴定Service
 * @author zhuoHeng
 * @version 2016-08-24
 */
@Service
@Transactional(readOnly = true)
public class DogTibetanMastiffService extends CrudService<DogTibetanMastiffDao, DogTibetanMastiff> {

	public DogTibetanMastiff get(String id) {
		return super.get(id);
	}
	
	public List<DogTibetanMastiff> findList(DogTibetanMastiff dogTibetanMastiff) {
		return super.findList(dogTibetanMastiff);
	}
	
	public Page<DogTibetanMastiff> findPage(Page<DogTibetanMastiff> page, DogTibetanMastiff dogTibetanMastiff) {
		return super.findPage(page, dogTibetanMastiff);
	}
	
	@Transactional(readOnly = false)
	public void save(DogTibetanMastiff dogTibetanMastiff) {
	    dogTibetanMastiff.setUpdateDate(new Date());
		dao.update(dogTibetanMastiff);
	}
	
	@Transactional(readOnly = false)
	public void delete(DogTibetanMastiff dogTibetanMastiff) {
		super.delete(dogTibetanMastiff);
	}

	/**
	 * 
	 * @Description：更改藏獒犬只鉴定审核状态
	 * @author: zhuoHeng
	 * @version: 2016年8月25日 上午10:19:48
	 */
	@Transactional(readOnly = false)
    public void changeStatus(DogTibetanMastiff dogTibetanMastiff) throws ZAException{
        DogTibetanMastiff tibetanMastiff = super.get(dogTibetanMastiff.getId());
        if("1".equals(tibetanMastiff.getReviewState())||"2".equals(tibetanMastiff.getReviewState())){
            throw new ZAException(-1, "当前审核流程已结束");
        } else {
            dogTibetanMastiff.setReviewTime(new Date());
            dao.changeStatus(dogTibetanMastiff);
        }
    }

	/**
	 * 
	 * @Description：添加藏獒犬只鉴定
	 * @author: zhuoHeng
	 * @version: 2016年8月25日 上午11:13:08
	 */
	@Transactional(readOnly = false)
    public void add(DogTibetanMastiff dogTibetanMastiff) {
	    dogTibetanMastiff.preInsert();
        dogTibetanMastiff.setReviewState("0");
        dogTibetanMastiff.setCreateDate(new Date());
        dogTibetanMastiff.setUpdateDate(new Date());
        dao.insert(dogTibetanMastiff);
    }
	
}