/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.breeder.dao;

import com.cku.oa.breeder.entity.StudDog;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 种公信息DAO接口
 *
 * @author lgl
 * @version 2017-10-13
 */
@MyBatisDao
public interface StudDogDao extends CrudDao<StudDog> {
    List<StudDog> getListOrderByDogBreed(Map map);

    List<StudDog> getList(Map map);

    long getCount(Map map);

    List<StudDog> getByMemberCode(@Param("memberCode") String memberCode,
    							  @Param("state") String state,
                                  @Param("pageNo") Integer pageNo,
                                  @Param("pageSize") Integer pageSize);

    long getCountByMemberCode(@Param("memberCode") String memberCode,@Param("state") String state);

    List<String> getDogBreedList();

    List<StudDog> search(Map map);

    long getSearchCount(Map map);

    void saveSearchParameter(Map map);

    List<StudDog> topList(@Param("pageSize") int pageSize);

    StudDog getByDogId(@Param("dogId")String dogId);

    void updateMemberCode(@Param("memberCode")String memberCode,@Param("dogId") String dogId);
}