/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.cab.editor.handlervenue.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import java.util.List;

import com.cku.cab.editor.groomervenue.entity.RestfulCkuImage;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 培训场馆Entity
 * @author zhuoHeng
 * @version 2016-11-25
 */
public class RestfulHandlerVenue {
	
	private String id;
	private String venueName;		// 举办地点
	private String venueLongitude;		// 精度
	private String venueLatitude;		// 纬度
	private String venueAddress;		// 场馆地址
	private String venuePhone;		// 场馆电话
	private Date createTime;		// 场馆创建时间
	private String showLocation;		// 业务关联-赛事场馆
	private List<RestfulCkuImage> ckuImage;
	

	
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Length(min=0, max=50, message="举办地点长度必须介于 0 和 50 之间")
	public String getVenueName() {
		return venueName;
	}

	public void setVenueName(String venueName) {
		this.venueName = venueName;
	}
	
	@Length(min=0, max=50, message="精度长度必须介于 0 和 50 之间")
	public String getVenueLongitude() {
		return venueLongitude;
	}

	public void setVenueLongitude(String venueLongitude) {
		this.venueLongitude = venueLongitude;
	}
	
	@Length(min=0, max=50, message="纬度长度必须介于 0 和 50 之间")
	public String getVenueLatitude() {
		return venueLatitude;
	}

	public void setVenueLatitude(String venueLatitude) {
		this.venueLatitude = venueLatitude;
	}
	
	public String getVenueAddress() {
		return venueAddress;
	}

	public void setVenueAddress(String venueAddress) {
		this.venueAddress = venueAddress;
	}
	
	@Length(min=0, max=20, message="场馆电话长度必须介于 0 和 20 之间")
	public String getVenuePhone() {
		return venuePhone;
	}

	public void setVenuePhone(String venuePhone) {
		this.venuePhone = venuePhone;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}
	
	@Length(min=0, max=255, message="业务关联-赛事场馆长度必须介于 0 和 255 之间")
	public String getShowLocation() {
		return showLocation;
	}

	public void setShowLocation(String showLocation) {
		this.showLocation = showLocation;
	}

	public List<RestfulCkuImage> getCkuImage() {
		return ckuImage;
	}

	public void setCkuImage(List<RestfulCkuImage> ckuImage) {
		this.ckuImage = ckuImage;
	}
	
}