package com.initSplit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

import com.alibaba.fastjson.JSONObject;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.timedtask.service.UfidaFitemSyncTask;
import com.ufida.api.request.CustomerAddRequest;
import com.ufida.api.vo.CustomerVo;

import openapi4j.service.CustomerService;

//@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration({ "classpath*:/spring-context*.xml" })
public class BaseInfoAddTest {
	@Autowired
	private MemberService memberService;
	@Autowired
	private UfidaFitemSyncTask zhangjunwuTask;

	// @Test
	public void testAddCustomer() throws Exception {

		Member entity = new Member();
		entity.setDelFlag("0");
		List<Member> memebers = memberService.findList(entity);
		memebers = memebers.stream()
				.filter(e -> new ArrayList<>(Arrays.asList(new String[] { "19207" })).contains(e.getMemberCode()))
				.collect(Collectors.toList());
		List<CustomerAddRequest> customerAddList = memebers.stream().map(m -> {
			return new CustomerAddRequest(new CustomerVo(m.getMemberCode(), m.getName(),
					m.getName() + "(" + m.getMemberCode() + ")", "02001"));
		}).collect(Collectors.toList());
		CustomerService customerService = new CustomerService();
		customerAddList.forEach(request -> {
			try {
				System.out.println(JSONObject.toJSONString(request, true));
				customerService.add(JSONObject.toJSONString(request, false), "ChongAiWG");
			} catch (Exception e) {
				e.printStackTrace();
			}
		});
	}

	// @Test
	public void testAddProject() throws Exception {
		zhangjunwuTask.executeOnce();
	}
}
