//学校美容师活动报名添加页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //活动类型
        me.activity = ko.observable({});
        //培训学校列表
        me.schoolList = ko.observable([]);
        //级别：A;B;C默认为A
        me.showLevel = ko.observable("A");
        //培训机构
        me.schoolNameCn = ko.observable("");
        //头像id
        me.avatar = ko.observable("1");
        //比赛犬种
        me.showDogBreed = ko.observable("");
        //选择的学校
        me.schoolText = ko.observable("请选择");
        //照片要求的显隐 默认隐
        me.pictureI = ko.observable(false);
        //照片要求的显隐事件
        me.isPicture = function(){
            me.pictureI(!me.pictureI());
        }
        //teacher提示框的显隐 默认隐
        me.isTeacher = ko.observable(false);
        //teacher提示框的显隐事件
        me.noLevel = function(){
            me.isTeacher(!me.isTeacher());
        }
        //教育机构的显隐 默认隐
        me.isSchoolNameCn = ko.observable(false);
        //教育机构的显隐事件
        me.showSchoolNameCn = function(){
            me.isSchoolNameCn(!me.isSchoolNameCn());
        }
        //提交成功框的显示隐藏 默认隐藏
        me.submitSuccess = ko.observable(false);
        /**
         * 获取活动类型
         */
        var data = util.getQueryString();
        var showType = data.showType;
        me.activity().type = showType;
        /**
         *选择级别
         */
        me.witchLevel = function(type){
            $("#showLevel a").removeAttr("class");
            $("#level"+type).attr("class","checked");
            if(type!="T"){
                me.showLevel(type);
                me.isTeacher(false);
            }else{
                me.showLevel("");
                me.isTeacher(!me.isTeacher());
            }
        }
        /**
         * 选择犬种
         */
        me.chooseDogBreed = function(type){
            $("#dogBreed a").removeAttr("class");
            $("#breed"+type).attr("class","checked");
            if(type!="N"){
                if(type=="B"){
                    me.showDogBreed("比熊")
                }else{
                    me.showDogBreed("贵宾")
                }
                $("#otherBreed").attr("disabled","disabled").val(" ");
            }else{
                $("#otherBreed").removeAttr("disabled");
            }
        }
        /**
         * 培训学校列表
         */
        me.getSchool = function(schoolType){
            var sendData = {};
            sendData["schoolType"] = schoolType;
            util.sendAjax({
                url:'trainschool/trainingInstitution',
                data:sendData,
                async:false,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        me.schoolList(data.list);
                    }else{
                        layer.msg(data.msg);
                    }
                }
            });
        }
        /**
         * 选择学校
         */
        me.witchShool = function(data,event){
            $("#school dd").removeAttr("class");
            $(event.target).parents("dd").attr("class","active");
            me.schoolText(data.schoolNameCn);
            me.schoolNameCn(data.schoolNameCn);
            me.isSchoolNameCn(!me.isSchoolNameCn());
            if($(event.target).text()!="请选择"){
                $("#otherSchool").val("").attr("disabled","disabled");
            }
        }
        /**
         * 提交申请
         */
        me.submitHandlerRegister = function(){
            var sendData = {};
            //获取活动id
            var data = util.getQueryString();
            var id = data.id;
            sendData["showCode"] = id;
            sendData["showLevel"] = me.showLevel();
            sendData["schoolNameCn"] = me.schoolNameCn();
            sendData["avatar"] = me.avatar();
            sendData["showDogBreed"] = me.showDogBreed();
            util.sendAjax({
                url:'groomer/groomerRegister',
                data: JSON.stringify(sendData),
                async:false,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        layer.msg("添加购物车成功！");
                        context.app.changeCart();
                    }else{
                        layer.msg(json.msg);
                    }
                }
            });
        }
        $(function(){
            me.getSchool("1");
        })
        context.app.loading(false);
        context.app.isShop(false);
    }
});

