<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>报名信息管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").attr("action","${ctxSchools}/schoolsGroomerRegister/groomerRegisterList");
			$("#searchForm").submit();
        	return false;
        }
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	
	<ul class="nav nav-tabs">
		<li class=""><a href="${ctxSchools}/schoolsGroomer/groomerShowList">美容师活动列表</a></li>
		<li class="active"><a href="${ctxSchools}/schoolsGroomerRegister/groomerRegisterList">美容师报名列表</a></li>
	</ul>
	
	<form:form id="searchForm" modelAttribute="groomerRegister" action="${ctxSchools}/schoolsGroomerRegister/groomerRegisterList" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号/姓名：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>赛事编号：</label>
				<form:input path="showCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>缴费状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="0" label="未审核"/>
					<form:option value="1" label="通过"/>
					<form:option value="2" label="未通过"/>
				</form:select>
			</li>
			<li><label>参赛级别：</label>
				<form:select path="showLevel" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('groomer_test_level')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>
			</li>
			
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>报名序号</th>
				<th>提交时间</th>
				<th>会员号</th>
				<th>姓名</th>
				<th>移动电话</th>
				<th>性别</th>
				<th>比赛犬种</th>
				<th>赛事编号</th>
				<th>活动分类</th>
				<th>参赛级别</th>
				<th>缴费状态</th>
				<th>审核状态</th>
				<th>成绩</th>
				<th>笔试成绩</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groomerRegister">
			<tr>
				<td>
					${fns:escapeHtml(groomerRegister.registerCode)}
				</td>
				<td>
					<fmt:formatDate value="${groomerRegister.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td title='${fn:replace(groomerRegister.teamMemberCode, ",", "  ")}'>
					${fns:escapeHtml(groomerRegister.memberCode)}
				</td>
				<td>
					${fns:escapeHtml(groomerRegister.name)}
				</td>
				<td>
					${fns:escapeHtml(groomerRegister.member.mobile)}
				</td>
				<td>
					${fns:getDictLabel(groomerRegister.member.gender, 'user_gender', '')}
				</td>
				<td>
					${fns:substringAfter(groomerRegister.showDogBreedStr,",")}
					${not empty groomerRegister.showDogBreedExtra?"# ":""}
					${fns:substringAfter(groomerRegister.showDogBreedExtra,",")}
				</td>
				<td>
					${fns:escapeHtml(groomerRegister.showCode)}
				</td>
				<td>
					${fns:getDictLabel(groomerRegister.groomerShow.showCategory, 'groomer_show_category', '')}
				</td>
				<td>
					<c:choose>
					    <c:when test="${groomerRegister.groomerShow.showCategory eq '4'}">
							${fns:getDictLabel(groomerRegister.showLevel, 'groomer_nurse_level', '')}
					    </c:when>
					    <c:otherwise>
					    	${fns:getDictLabels(groomerRegister.showLevel, 'groomer_test_level', '')}
					    </c:otherwise>
					</c:choose>
				</td>
				
				<td>
					<c:choose>
						<c:when test="${groomerRegister.paymentState=='1'}">
							<a style="color:red;" href="${ctxSchools}/payment/groomerRegisterPay?groomerRegisterId=${groomerRegister.id}">${fns:getDictLabel(groomerRegister.paymentState,'user_payment_state','')}</a>
						</c:when>
						<c:when test="${groomerRegister.paymentState=='2'}">
							<font color="green">${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}</font>
						</c:when>
					</c:choose>
				</td>
				
				<td>
					<c:choose>
					<c:when test="${groomerRegister.reviewState=='0' }">
							<font color="">${fns:getDictLabel(groomerRegister.reviewState, 'review_state', '')}</font>
					</c:when>
					<c:when test="${groomerRegister.reviewState=='1' }">
							<font color="green">${fns:getDictLabel(groomerRegister.reviewState, 'review_state', '')}</font>
					</c:when>
					<c:when test="${groomerRegister.reviewState=='2' }">
						<font color="red" title="${fns:escapeHtml(groomerRegister.reviewRemarks)}">${fns:getDictLabel(groomerRegister.reviewState, 'review_state', '')}</font>
					</c:when>
					</c:choose>
				</td>
				<td>
					${fns:getDictLabel(groomerRegister.grade, 'Grade', '')}
				</td>
				<td>
					${fns:getDictLabel(groomerRegister.gradeWrite, 'grade_write', '')}
				</td>
				<td>					
				<a href="${ctxSchools}/schoolsGroomerRegister/view?id=${fns:escapeHtml(groomerRegister.id)}">查看</a>
    			
    			<c:if test="${groomerRegister.reviewState  ne '1'}">
    			<a href="${ctxSchools}/schoolsGroomerRegister/form?id=${fns:escapeHtml(groomerRegister.id)}">编辑</a>
				</td>
				</c:if>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>