<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只信息管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctxPartner}/clubDog/">犬只信息列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="clubDog" action="${ctxPartner}/clubDog/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>鉴定编号：</label>
				<form:input path="identifyCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>鉴定证书号：</label>
				<form:input path="pedigreeCertifiedCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns" style="float:right"><a  class="btn btn-primary"  href="${ctxPartner}/clubDog/form" >录入犬只信息</a></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>鉴定编号</th>
				<th>鉴定证书号</th>
				<th>登记时间</th>
				<th>审核状态</th>
				<th>缴费状态</th>
				<th>操作</th>
				<th>打印状态</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="clubDog">
			<tr>
				<td>
					${clubDog.identifyCode}
				</td>
				<td>
					${clubDog.pedigreeCertifiedCode}
				</td>
				<td>
					<fmt:formatDate value="${clubDog.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<c:if test="${clubDog.reviewState=='1'}">
						<font style="color:green;">已审核</font>
					</c:if>
					<c:if test="${clubDog.reviewState !='1' }">
						<font style="color:red">${fns:getDictLabel(clubDog.reviewState, 'review_state', '')}</font>
					</c:if>
				</td>
				<td>
					<c:if test="${clubDog.paymentState=='2'}">
						<font style="color:green;">已缴费</font>
					</c:if>
					<c:if test="${clubDog.paymentState =='1' }">
						<a style="color:red" href="${ctxPartner}/clubDog/paymentOrder?id=${clubDog.id}">缴费</a>
					</c:if>
				</td>
				<td>
				    <a href="${ctxPartner}/clubDog/viewForm?id=${clubDog.id}">查看</a>
					<c:if test="${clubDog.paymentState=='1'||clubDog.firstPrint=='0'}">
    				<a href="${ctxPartner}/clubDog/editForm?id=${clubDog.id}">修改</a>
					</c:if>
				</td>
				<td>
					<c:if test="${clubDog.printState=='0'&& not empty  clubDog.pedigreeCertifiedCode }">
						<a href="${ctxPartner}/clubDog/print?id=${clubDog.id}" onclick="return confirmx('确认要打印吗？', this.href)">打印</a>
					</c:if>
					<c:if test="${clubDog.printState=='1'}">
						<a href="${ctxPartner}/clubDog/restPrint?id=${clubDog.id}">重置打印</a>
					</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>