<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>淘宠宝犬舍管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/tcb/tcbKennel/">淘宠宝犬舍列表</a></li>
		<li class="active">淘宠宝犬舍查看</li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="tcbKennel" action="${ctx}/tcb/tcbKennel/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<h3>会员基本信息</h3>
		<div class="control-group">
			<label class="control-label">会员编号：</label>
			<div class="controls">
				${fns:escapeHtml(tcbKennel.memberCode)}
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">会员姓名：</label>
			<div class="controls">
				${fns:escapeHtml(tcbKennel.member.name)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				${fns:getDictLabels(tcbKennel.member.gender, 'user_gender', '')}
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">证件类型：</label>
			<div class="controls">
				${fns:escapeHtml(tcbKennel.member.cardType)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证件编号：</label>
			<div class="controls">
				${fns:escapeHtml(tcbKennel.member.cardNo)}
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">手机号码：</label>
			<div class="controls">
				${fns:escapeHtml(tcbKennel.member.mobile)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">联系地址：</label>
			<div class="controls">
				${fns:escapeHtml(tcbKennel.member.address)}
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">会员类型：</label>
			<div class="controls">
				${fns:getDictLabels(tcbKennel.member.memberType, 'user_member_type', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">截止日期：</label>
			<div class="controls">
				<fmt:formatDate value="${tcbKennel.member.memberEndDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">犬舍名称：</label>
			<div class="controls">
				${fns:escapeHtml(tcbKennel.kennel.name)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">截止日期：</label>
			<div class="controls">
				<fmt:formatDate value="${tcbKennel.kennel.endTime}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div style = "clear:both;"/>
		<h3>项目信息</h3>
		<div class="control-group">
			<label class="control-label">项目名称：</label>
			<div class="controls">
				淘宠犬舍
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">开始日期：</label>
			<div class="controls">
				<fmt:formatDate value="${tcbKennel.startDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">结束日期：</label>
			<div class="controls">
				<fmt:formatDate value="${tcbKennel.endDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">合同编号：</label>
			<div class="controls">
				${fns:escapeHtml(tcbKennel.contractCode)}
			</div>
		</div>
		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				${fns:escapeHtml(tcbKennel.remarks)}
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>