<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>合作机构、合作医院管理</title>
	<meta name="decorator" content="default"/>
	<link href="${ctxStatic}/layui_2/layui/css/layui.css" type="text/css" rel="stylesheet"/>
	<script src="${ctxStatic}/layui_2/layui/layui.all.js" type="text/javascript"></script>
	<style>
		.picDiv>div{
			width:33%;
		}
	</style>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			$("input:radio[name='noseLine']").eq(${org.noseLine}).attr("checked",'checked');
			//会员中心是否显示回显
			$("input:radio[name='visibleFlag']").eq(${org.visibleFlag}).attr("checked",'checked');


		});
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/sys/org/">合作机构列表</a></li>
		<li class="active"><a href="${ctx}/sys/org/form?id=${org.id}">合作机构<shiro:hasPermission name="sys:org:edit">${not empty org.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="sys:org:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="org" action="${ctx}/sys/org/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">机构类型：</label>
			<div class="controls">
				${fns:getDictLabel(org.orgType,'sys_org_type','')}
			</div>
		</div>
		<div style="clear:both;"></div>
		<div class="control-group">
			<label class="control-label">CKU会员号：</label>
			<div class="controls">
				<%--<c:if test="${org.orgType eq 'club'}">--%>
				${org.memberCode }<%--</c:if>--%>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">登录帐号：</label>
			<div class="controls">
				${fns:escapeHtml(org.user.loginName)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">登录密码：</label>
			<div class="controls">
				<input type="password" name="user.password" class="input-xlarge" />
				<span class="help-inline"><font color="red">空值为不修改</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">机构名称：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">联系人：</label>
			<div class="controls">
				<form:input path="contact" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">联系电话：</label>
			<div class="controls">
				<form:input path="tel" htmlEscape="false" maxlength="50" class="input-xlarge required isTel"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
				<div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				<form:select id="province" path="province" class="input-small required">
					<form:option value=""></form:option>
					<c:forEach items="${province}" var="p">
						<form:option value="${fns:escapeHtml(p.name) }">${fns:escapeHtml(p.name) }</form:option>
					</c:forEach>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">城市：</label>
			<div class="controls">
				<form:select id="city" path="city" class="input-small required">
					<form:option value=""></form:option>
					<c:forEach items="${city}" var="c">
						<form:option value="${fns:escapeHtml(c.name) }">${fns:escapeHtml(c.name) }</form:option>
					</c:forEach>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#province").change(function(){
				var extId = $("#province").val();
				extId = encodeURI(extId);
				//异步请求数据
				var url="${ctx}"+"/sys/area/treeData";
				$.get(url,{extId:extId},function(data){
					var content = "<option value=''></option>";
					for(var i in data){
						content+="<option value='"+data[i].name+"'>"+data[i].name+"</option>"
					}
					$("#city").html(content).trigger("change");
				},"json")
			})
		</script>
		<div class="control-group">
			<label class="control-label">街道：</label>
			<div class="controls">
				<form:input path="street" htmlEscape="false" maxlength="200" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">地址：</label>
			<div class="controls">
				<form:input path="address" htmlEscape="false" readonly="true" maxlength="200" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">官网显示：</label>
			<div class="controls">
				<form:radiobuttons path="displayOnWeb" items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">座机电话：</label>
			<div class="controls">
				<form:input path="landlinePhone" htmlEscape="false" class="input-xlarge number"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">截止日期：</label>
			<div class="controls">
				<input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					   value="<fmt:formatDate value="${org.endDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">押金：</label>
			<div class="controls">
				<form:input path="deposit" htmlEscape="false" class="input-xlarge number"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">缴纳押金的时间：</label>
			<div class="controls">
				<input name="depositDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${org.depositDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">芯片扫描仪：</label>
			<div class="controls">
				<input type="radio" name="scanner" value="yes"/>是
				<input type="radio" name="scanner" value="no" checked="checked"/>否
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员中心显示：</label>
			<div class="controls">
				<input type="radio" name="visibleFlag" value="0"/>是
				<input type="radio" name="visibleFlag" value="1"/>否
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">芯片埋置情况：</label>
			<div class="controls" style="color:green;">
				已埋置芯片数:${count_off} &nbsp;&nbsp;&nbsp;总芯片数:${count_over}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">采血器材情况：</label>
			<div class="controls" style="color:green;">
				采血器数量:${blood_card_sum} &nbsp;&nbsp;&nbsp;采血器使用数量:${dna_blood}<br/>
				采血卡数量:${draw_blood_sum} &nbsp;&nbsp;&nbsp;采血卡使用数量:${dna_archive}
			</div>
		</div>
		<%-- <div style = "clear:both;"></div>
		<div class="control-group" style="clear:left;float: left">
			<label class="control-label">C级鉴定师：</label>
			<div class="controls">
				<form:input path="jianDingshi1" htmlEscape="false" class="input-small "/>
				<form:input path="jianDingshi2" htmlEscape="false" class="input-small "/>
			</div>
		</div> --%>
		<div class="control-group">
			<label class="control-label">归属机构：</label>
			<div class="controls">
				<form:select id="" path="tuijiansren" class="input-xlarge ">
					<form:option value="">请选择归属机构</form:option>
					<c:forEach items="${orgType}" var="p">
						<form:option value="${fns:escapeHtml(p.id) }">${fns:escapeHtml(p.name) }</form:option>
					</c:forEach>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				<form:select path="shenHeState" class="input-small">
					<form:option value="0">待审核</form:option>
					<form:option value="1">通过</form:option>
					<form:option value="2">未通过</form:option>
				</form:select>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="picDiv">
			<div class="control-group" style="float: left">
				<label class="control-label">营业执照照片：</label>
				<div class="controls">
					<div style="">
						<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;">
							<center><img id="previewCatImg" alt=""
										 src="${ctx}/sys/file/image/${org.yingyePic}"
										 style="padding:10px;height:130px;"/></center>
							<div style="position:relative;color: #cccccc;font-size: 18px;">
								<center>图片预览</center>
							</div>
						</div>
					</div>
					<div style="">
						<div style="border: 0px dashed #e6e6e6;margin:20px;min-height: 50px;position:relative;">
							<button type="button" style="height:40px;left:36%; position:absolute;  top:38%;" class="layui-btn"
									id="catImgUpload">
								<i class="layui-icon">&#xe67c;</i>上传图片
							</button>
							<form:input path="yingyePic" htmlEscape="false" maxlength="255" class="input-xlarge required"
										type="hidden"/>
						</div>
					</div>
					<script type="text/javascript">
						layui.use('upload', function () {
							var upload = layui.upload;
							//执行实例
							var uploadInst = upload.render({
								elem: '#catImgUpload' //绑定元素
								, url: '${ctx}/sys/file/layupload' //上传接口ctx
								, done: function (res) {//上传完毕回调
									$("#yingyePic").val(res.id);
									$("#previewCatImg").attr("src", res.url);
								}
								, error: function () {
									//请求异常回调
								}
							});
						});
					</script>
				</div>
			</div>
			<div class="control-group" style="float: left">
				<label class="control-label">兽医资格照片：</label>
				<div class="controls">
					<div style="">
						<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;">
							<center><img id="previewCatImgs" alt=""
										 src="${ctx}/sys/file/image/${org.shouYiPic}"
										 style="padding:10px;height:130px;"/></center>
							<div style="position:relative;color: #cccccc;font-size: 18px;">
								<center>图片预览</center>
							</div>
						</div>
					</div>
					<div style="">
						<div style="border: 0px dashed #e6e6e6;margin:20px;min-height: 50px;position:relative;">
							<button type="button" style="height:40px;left:36%; position:absolute;  top:38%;" class="layui-btn"
									id="catImgUploads">
								<i class="layui-icon">&#xe67c;</i>上传图片
							</button>
							<form:input path="shouYiPic" htmlEscape="false" maxlength="255" class="input-xlarge required"
										type="hidden"/>
						</div>
					</div>
					<script type="text/javascript">
						layui.use('upload', function () {
							var upload = layui.upload;
							//执行实例
							var uploadInst = upload.render({
								elem: '#catImgUploads' //绑定元素
								, url: '${ctx}/sys/file/layupload' //上传接口ctx
								, done: function (res) {//上传完毕回调
									$("#shouYiPic").val(res.id);
									$("#previewCatImgs").attr("src", res.url);
								}
								, error: function () {
									//请求异常回调
								}
							});
						});
					</script>
				</div>
			</div>
			<div class="control-group" style="float: left">
				<label class="control-label">门店照：</label>
				<div class="controls">
					<div style="">
						<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;">
							<center><img id="previewCatImgss" alt=""
										 src="${ctx}/sys/file/image/${org.mendian1Pic}"
										 style="padding:10px;height:130px;"/></center>
							<div style="position:relative;color: #cccccc;font-size: 18px;">
								<center>图片预览</center>
							</div>
						</div>
					</div>
					<div style="">
						<div style="border: 0px dashed #e6e6e6;margin:20px;min-height: 50px;position:relative;">
							<button type="button" style="height:40px;left:36%; position:absolute;  top:38%;" class="layui-btn"
									id="catImgUploadss">
								<i class="layui-icon">&#xe67c;</i>上传图片
							</button>
							<form:input path="mendian1Pic" htmlEscape="false" maxlength="255" class="input-xlarge required"
										type="hidden"/>
						</div>
					</div>
					<script type="text/javascript">
						layui.use('upload', function () {
							var upload = layui.upload;
							//执行实例
							var uploadInst = upload.render({
								elem: '#catImgUploadss' //绑定元素
								, url: '${ctx}/sys/file/layupload' //上传接口ctx
								, done: function (res) {//上传完毕回调
									$("#mendian1Pic").val(res.id);
									$("#previewCatImgss").attr("src", res.url);
								}
								, error: function () {
									//请求异常回调
								}
							});
						});
					</script>
				</div>
			</div>
			<div class="control-group" style="float:left">
				<label class="control-label">所属协会：</label>
				<div class="controls">
					<form:checkboxes items="${fns:getDictList('org_site')}" path="orgSiteArr" itemLabel="label" itemValue="value" htmlEscape="false"/>

				</div>
			</div>
			<div class="control-group" style="float:left">
				<label class="control-label">鼻纹识别：</label>
				<div class="controls">
					<input type="radio" name="noseLine" value="0"/>开通
					<input type="radio" name="noseLine" value="1"/>关闭
				</div>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="form-actions">
			<shiro:hasPermission name="sys:org:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>