<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>商城订单管理</title>
    <meta name="decorator" content="default"/>
    <link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/shop/shopOrder/">订单列表</a></li>
    <li><a href="${ctx}/shop/shopOrder/form">订单添加</a></li>
    <li class="active"><a href="${ctx}/shop/shopOrder/view?id=${shopOrder.id}">订单详情</a></li>
</ul><br/>
    <div class="form-horizontal">
        <div class="control-group">
            <label class="control-label">订单号：</label>
            <label class="control-label" style="width:80%;text-align: left;">
            ${fns:escapeHtml(shopOrder.shopOrderCode)}
            </label>
        </div>

        <div class="control-group">
            <label class="control-label">订单类型：</label>
                <label class="control-label" style="width:80%;text-align: left;">
                   ${fns:getDictLabel(shopOrder.type, 'channel_type', '')}
                </label>
        </div>

        <div class="control-group">
            <label class="control-label">会员编号：</label>
            <label class="control-label" style="width:80%;text-align: left;">
                ${fns:escapeHtml(shopOrder.memberCode)}
            </label>
        </div>

        <div class="control-group">
            <label class="control-label">会员姓名：</label>
            <label class="control-label" style="width:80%;text-align: left;">
                ${fns:escapeHtml(shopOrder.memberName)}
            </label>
        </div>

        <div class="control-group">
            <label class="control-label">收货人：</label>
            <label class="control-label" style="width:80%;text-align: left;">
                ${fns:escapeHtml(shopOrder.postName)}
            </label>
        </div>

        <div class="control-group">
            <label class="control-label">联系电话：</label>
            <label class="control-label" style="width:80%;text-align: left;">
                ${fns:escapeHtml(shopOrder.postDel)}
            </label>
        </div>

        <div class="control-group">
            <label class="control-label">收货地址：</label>
            <table class="table table-striped table-bordered table-condensed">
                <tr><td>所在省市</td><td> 所在市/区</td><td>详细地址</td></tr>
                <tr><td>${fns:escapeHtml(shopOrder.province)}</td><td>${fns:escapeHtml(shopOrder.city)}</td><td>${fns:escapeHtml(shopOrder.address)}</td></tr>
            </table>
            <c:if test="${shopOrder.orderDetailList!=null || fn:length(shopOrder.orderDetailList)>0}">
                <div style="height:${fn:length(shopOrder.orderDetailList)*29}px"></div>
            </c:if>
        </div>

        <div class="control-group">
            <label class="control-label">购买商品：</label>
                <table class="table table-striped table-bordered table-condensed" >
                    <thead>
                    <tr>
                        <td>名称</td><td>单价</td><td>数量</td><td>备注</td><td>邮费</td><td>总价</td>
                    </tr>
                    </thead>
                    <tbody>
                    <c:forEach items="${shopOrder.orderDetailList}" var="orderDetail">
                        <tr>
                            <td>${orderDetail.goodsName}</td><td>${orderDetail.goodsPrice}</td><td>${orderDetail.goodsNum}</td><td>${orderDetail.isBuyGifts=='0'?'':'赠品'}</td><td>${orderDetail.postPrice}</td><td>${orderDetail.totalPrice}</td>
                        </tr>
                    </c:forEach>
                    <tr>
                        <td>合计</td><td><div style="border-top:1px solid #000;width:30px;height:1px;"> </div></td><td>${shopOrder.num}</td><td><div style="border-top:1px solid #000;width:30px;height:1px;"> </div></td><td>${shopOrder.postPrice}</td><td>${shopOrder.price}</td>
                    </tr>
                    </tbody>
                </table>
        </div>

        <div class="control-group">
            <label class="control-label">买家留言：</label>
            <label class="control-label" style="width:80%;text-align: left;">
                ${fns:escapeHtml(shopOrder.message)}
            </label>
        </div>

        <div class="control-group">
            <label class="control-label">销售渠道：</label>
            <label class="control-label" style="width:80%;text-align: left;">
                ${fns:getDictLabel(shopOrder.channelType, 'channel_type','' )}-${shopOrder.channelName}
            </label>
        </div>

        <div class="control-group">
            <label class="control-label">下单时间：</label>
            <label class="control-label" style="width:80%;text-align: left;">
                    <fmt:formatDate value="${shopOrder.orderDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </label>
        </div>

        <div class="control-group">
            <label class="control-label">付款时间：</label>
            <label class="control-label" style="width:80%;text-align: left;">
                    <fmt:formatDate value="${shopOrder.paymentDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </label>
        </div>

        <div class="control-group">
            <label class="control-label">支付方式：</label>
            <label class="control-label" style="width:80%;text-align: left;">
                ${fns:getDictLabel(shopOrder.paymentWay,'payment_way' ,"现金缴纳" )}
            </label>
        </div>

        <div class="control-group">
            <label class="control-label">支付状态：</label>
            <label class="control-label" style="width:80%;text-align: left;">
                ${fns:getDictLabel(shopOrder.paymentState, 'user_payment_state', '')}
            </label>
        </div>

        <div class="control-group">
            <label class="control-label">发货状态：</label>
            <label class="control-label" style="width:80%;text-align: left;">
                    <c:if test="${shopOrder.isSend=='0'}">
                    未发货
                    </c:if>
                    <c:if test="${shopOrder.isSend=='1'}">
                      已发货
                    </c:if>
            </label>
        </div>

        <div class="control-group">
            <label class="control-label">快递公司：</label>
            <label class="control-label" style="width:80%;text-align: left;">
                <c:choose>
                    <c:when test="${shopOrder.sendPostType=='zhongtie'}">
                        中铁物流
                    </c:when>
                    <c:when test="${shopOrder.sendPostType=='sutong'}">
                        速通物流
                    </c:when>
                    <c:when test="${shopOrder.sendPostType=='yunda'}">
                        韵达快递
                    </c:when>
                    <c:when test="${shopOrder.sendPostType=='cku'}">
                        协会配送
                    </c:when>
                    <c:otherwise>
                        无
                    </c:otherwise>
                </c:choose>
            </label>
        </div>

        <div class="control-group">
            <label class="control-label">发货单号：</label>
            <label class="control-label" style="width:80%;text-align: left;">
                ${fns:escapeHtml(shopOrder.sendPostOrderNo)}
            </label>
        </div>

        <div class="control-group">
            <label class="control-label">订单备注：</label>
            <label class="control-label" style="width:80%;text-align: left;">
                ${fns:escapeHtml(shopOrder.remarks)}
            </label>
        </div>

        <div style = "clear:both;"></div>
    </div>
</body>
</html>