<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>成绩管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
			
			$("#btnImport").click(function(){
				$.jBox($("#importBox").html(), {title:"成绩导入", buttons:{"关闭":true}, 
					bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
			});
			// 选择下拉列表
			var $select = $('#showCategoryClass');

			// 遍历所有的 <option> 元素
			$select.find('option').each(function() {
				// 检查 value 是否等于 5 为FCI增发类型，不展示
				if ($(this).val() === '5') {
					// 从下拉列表中移除该 <option>
					$(this).remove();
				}
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
        
		//录入成绩  
		function inputForm(id){
			parent.layer.open({
				type: 2,
				title: ['成绩录入', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '500px'],
				content: ctx+"/groomer/groomerRegister/inputForm?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
		
		//录入成绩   教师
		function inputFormM(id){
			parent.layer.open({
				type: 2,
				title: ['成绩录入', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '500px'],
				content: ctx+"/groomer/groomerRegister/inputFormM?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
		//修改笔试成绩
		function bind(id){
			parent.layer.open({
				type: 2,
				title: ['修改笔试成绩', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['500px', '250px'],
				content: "${ctx}/groomer/groomerRegister/gradeViewEdit?id="+id,
			});
			return false;
		}
		function bindGroomerRegisterCallback(data){
			window.location.reload();
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><shiro:hasPermission name="groomer:grade:view"><a href="${ctx}/groomer/groomerRegister/grade">成绩管理</a></shiro:hasPermission></li>
	</ul>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/groomer/groomerRegister/import" method="post" enctype="multipart/form-data"
			class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
		</form>
	</div>
	<form:form id="searchForm" modelAttribute="groomerRegister" action="${ctx}/groomer/groomerRegister/grade" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号/姓名：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>赛事编号：</label>
				<form:input path="showCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>报名序号：</label>
				<form:input path="registerCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>成绩：</label>
				<form:select path="grade" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('Grade')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li>
				<label>活动分类：</label>
				<form:select path="showCategory" id="showCategoryClass" class="input-small">
					<form:option value="">全部</form:option>
					<form:options items="${fns:getDictList('groomer_show_category')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>赛事级别：</label>
				<form:select path="showLevel" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('groomer_test_level')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
<!-- 			<li><label>名次：</label> -->
<%-- 				<form:input path="place" htmlEscape="false" maxlength="64" class="input-medium"/> --%>
<!-- 			</li> -->
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/>
			<shiro:hasPermission name="groomer:grade:import">
				<input id="btnImport" class="btn btn-primary" type="button" value="导入"/>
			</shiro:hasPermission>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<div>
		<span style="color: red;display: inline-block;width: 100%;text-align: center;">“请务必在上传实操成绩/笔试成绩前，确认会员所报名的赛事级别正确，如有调整请前往活动管理—>报名信息管理”中进行更改！</span>
	</div>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>报名序号</th>
				<th>会员号</th>
				<th>姓名</th>
				<th>美容师类型</th>
				<th>性别</th>
				<th>移动电话</th>
				<th>培训学校</th>
				<th>比赛犬种</th>
				<th>赛事编号</th>
				<th>活动分类</th>
				<th>赛事级别</th>
<!-- 				<th>名次</th> -->
				<shiro:hasPermission name="groomer:grade:edit"><th>实操成绩</th></shiro:hasPermission>
				<th>笔试成绩</th>
				<th>查看</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groomerRegister">
			<tr>
				<td>
				${fns:escapeHtml(groomerRegister.registerCode)}
				</td>
				<td>
					<a href="${ctx}/sys/user/member/toMemberView?memberCode=${groomerRegister.memberCode}">
					${fns:escapeHtml(groomerRegister.memberCode)}
					</a>
				</td>
				<td>
					${fns:escapeHtml(groomerRegister.name)}
				</td>
				<td>
					${fns:getDictLabels(groomerRegister.member.groomerType, 'user_groomer_type', '无')}
				</td>
				<td>
					${fns:getDictLabel(groomerRegister.member.gender, 'user_gender', '')}
				</td>
				<td>
					${fns:escapeHtml(groomerRegister.member.mobile)}
				</td>
				<td>
					${fns:escapeHtml(groomerRegister.schoolNameCn)}
				</td>
				<td>
					${fn:replace(groomerRegister.showDogBreed, ",", "  ")}
					${empty groomerRegister.showDogBreed ? '':' '}
					${fn:replace(groomerRegister.showDogBreedExtra, ",", "  ")}
				</td>
				<td>
					${fns:escapeHtml(groomerRegister.showCode)}
				</td>
				<td>
					${fns:getDictLabel(groomerRegister.groomerShow.showCategory, 'groomer_show_category', '')}
				</td>
				<td>
					<c:if test="${groomerRegister.groomerShow.showCategory ne '4'}">
						${fns:getDictLabel(groomerRegister.showLevel, 'groomer_test_level', '')}
					</c:if>
					<c:if test="${groomerRegister.groomerShow.showCategory eq '4'}">
						${fns:getDictLabel(groomerRegister.showLevel, 'groomer_nurse_level', '')}
					</c:if>
				</td>
<!-- 				<td> -->
<%-- 						${fns:escapeHtml(groomerRegister.place)} --%>
<!-- 				</td> -->
				<shiro:hasPermission name="groomer:grade:edit">
				<td title="${fns:escapeHtml(groomerRegister.referee)}">
					<c:choose>
						<c:when test="${groomerRegister.grade==null}">
							<c:if test="${groomerRegister.showLevel!='MASTER'}">
							  <a   onclick="inputForm('${fns:escapeHtml(groomerRegister.id)}')" >录入成绩</a>
							</c:if>
							<c:if test="${groomerRegister.showLevel=='MASTER'}">
								<a   onclick="inputFormM('${fns:escapeHtml(groomerRegister.id)}')" >录入成绩</a>
							</c:if>
						</c:when>
						<c:when test="${groomerRegister.grade=='0' or groomerRegister.grade=='1'}">
							<font color="red">${fns:getDictLabel(groomerRegister.grade, 'Grade', '')}</font>
						</c:when>
						<c:otherwise>
							<font color="green">${fns:getDictLabel(groomerRegister.grade, 'Grade', '')}</font>
						</c:otherwise>
					</c:choose>
				</td>
				</shiro:hasPermission>
				<td>
					<%--<c:choose>
						<c:when test="${groomerRegister.gradeWrite=='0'}">
							<font color="red">${fns:getDictLabel(groomerRegister.gradeWrite, 'grade_write', '')}</font>
						</c:when>
						<c:when test="${groomerRegister.gradeWrite=='1'}">
							<font color="green">${fns:getDictLabel(groomerRegister.gradeWrite, 'grade_write', '')}</font>
						</c:when>
						&lt;%&ndash;<c:when test="${groomerRegister.gradeWrite=='2'}">
							<font color="green">待考试</font>
						</c:when>&ndash;%&gt;
						<c:otherwise>
							<c:choose>
								<c:when test="${empty groomerRegister.grade}">
									<font color="red"></font>
								</c:when>
								<c:otherwise>
									<font color="red">待考试</font>
								</c:otherwise>
							</c:choose>
						</c:otherwise>
					</c:choose>--%>
						<font color="red">${fns:getDictLabel(groomerRegister.gradeWrite, 'grade_write', '')}</font>
				</td>
				<td>
					<a href="${ctx}/groomer/groomerRegister/gradeView?id=${fns:escapeHtml(groomerRegister.id)}">查看</a>
					<shiro:hasPermission name="groomer:grade:view">
						<a href="javascript:;"  onclick="bind('${fns:escapeHtml(groomerRegister.id)}')">编辑</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>