<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容师结业证书管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
			
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/groomer/groomerDiploma/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
		});
	
		function page(n,s){
			if(n) $("#pageNo").val(n);
			if(s) $("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/groomer/groomerDiploma/");
			$("#searchForm").submit();
	    	return false;
	    }
	/* 	function showLayer(id){
			var remarks = "";
			parent.layer.prompt({
				title: ['拒绝原因', 'font-size:18px;text-align: center;'],
				formType: 2
			}, function(text){
				remarks = text;
				window.location.href="${ctx}/groomer/groomerDiploma/review?id="+id+"&type=fail&remarks="+remarks;
				parent.layer.closeAll();
			});

		} */
		//批量生成
		function listCreate(){
				var id="";
				$(".checkedId:checked").each(function(){
					id+=$(this).attr("groomerId")+',';
				});
				if (id!="") {
					$.ajax({
		                type:"POST",
		                url: ctx+"/groomer/groomerDiploma/createCode",
		                data : {'id':id},
		                dataType: 'json',
		                success: function(json){
		                	if (json.rc==0) {
		                		$("#searchForm").submit();
							}else{
								$.jBox.alert(json.msg,"提示");
							}
		                }
					}); 
				}else{
					$.jBox.alert("请勾选需要生成的结业证书记录!");
				}
			}
		//批量审核通过
		function listSubmit(){
				var id="";
				$(".checkedId:checked").each(function(){
					id+=$(this).attr("groomerId")+',';
				});
				if (id!="") {
					$.ajax({
		                type:"POST",
		                url: ctx+"/groomer/groomerDiploma/listSubmit",
		                data : {'id':id},
		                dataType: 'json',
		                success: function(json){
		                	if (json.rc==0) {
		                		$("#searchForm").submit();
							}else{
								$.jBox.alert(json.msg,"提示");
							}
		                }
					}); 
				}else{
					$.jBox.alert("请勾选需要通过的结业记录");
				}
			}
		
		/* //获取选中的值
		function check(){
			var id="";
			$(".checkedId:checked").each(function(){
				id+=$(this).attr("groomerId")+',';
			});
			alert(id);
		} */
		//全选事件 选中/取消选中
		var b=false;
		function allCheck(){
			if (!b) {
				b=true;
				$(".checkedId").each(function(){
					$(this).attr("checked", b);
				});
			}else{
				b=false;
				$(".checkedId").each(function(){
					$(this).attr("checked", b);
				});
			}
		}
		
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/groomer/groomerDiploma/">美容师结业证书列表</a></li>
		<li><shiro:hasPermission name="groomer:groomerDiploma:edit"><a href="${ctx}/groomer/groomerDiploma/addform">美容师结业证书添加</a></shiro:hasPermission></li>
	</ul>
	<form:form id="searchForm" modelAttribute="groomerDiploma" action="${ctx}/groomer/groomerDiploma/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<%-- <li><label>姓名：</label>
				<form:input path="name" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li> --%>
			<li><label>姓名/会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>证书编号：</label>
				<form:input path="certificateCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>证书级别：</label>
				<form:select path="certificateLevel" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('groomer_test_level')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>学校名：</label>
				<form:input path="schoolNameCn" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('diploma_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>缴费状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li>
				<label>缴费日期：</label>
				<input name="beginDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${groomerDiploma.beginDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="lastDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${groomerDiploma.lastDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>
			<shiro:hasPermission name="groomer:groomerDiploma:export"><button id="btnExport" type="button" class="btn btn-primary" >导出</button></shiro:hasPermission>
			<shiro:hasPermission name="groomer:groomerDiploma:audit"><a href="#" onclick="listSubmit()"><input class="btn btn-primary" type="button" value="批量通过" /></a></shiro:hasPermission>
			<shiro:hasPermission name="groomer:groomerDiploma:create"><a href="#" onclick="listCreate()"><input class="btn btn-primary" type="button" value="批量生成" /></a></shiro:hasPermission>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th><a href="#" onclick="allCheck()">全选</a></th>
				<th>会员号</th>
				<th>姓名</th>
				<th>美容师类型</th>
				<th>开始时间</th>
				<th>结束时间</th>
				<th>培训教师</th>
				<th>证书级别</th>
				<th>中文学校名</th>
				<th>缴费日期</th>
				<shiro:hasPermission name="groomer:groomerDiploma:create"><th>证书编号</th></shiro:hasPermission>
				<shiro:hasPermission name="groomer:groomerDiploma:create"><th>签发日期</th></shiro:hasPermission>
				<th>缴费状态</th>
				<th>操作</th>
				<th>审核状态</th>
				<th>打印</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groomerDiploma">
			<tr>
				<td><input type="checkbox" class="checkedId" groomerId="${fns:escapeHtml(groomerDiploma.id)}"></td>
				<td><a href="${ctx}/sys/user/member/toMemberView?memberCode=${groomerDiploma.memberCode}">
					${fns:escapeHtml(groomerDiploma.memberCode)}
				</a>
				</td>
				<td>
					${fns:escapeHtml(groomerDiploma.name)}
				</td>
				<td>
					${fns:getDictLabels(groomerDiploma.member.groomerType, 'user_groomer_type', '无')}
				</td>
				<td>
					<fmt:formatDate value="${groomerDiploma.startDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${groomerDiploma.endDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:escapeHtml(groomerDiploma.teacher)}
				</td>
				<td>
					美容师${fns:getDictLabel(groomerDiploma.certificateLevel, 'groomer_test_level', '')}级
				</td>
				<td>
					${fns:escapeHtml(groomerDiploma.schoolNameCn)}
				</td>
			 	<td>
					<fmt:formatDate value="${groomerDiploma.paymentTime}" pattern="yyyy-MM-dd"/>
				</td> 
				<shiro:hasPermission name="groomer:groomerDiploma:create">
				<td>
					<c:choose>
						<c:when test="${ groomerDiploma.reviewState=='1' &&  empty fns:escapeHtml(groomerDiploma.certificateCode)  }">
							<a href="${ctx}/groomer/groomerDiploma/createCodeOne?id=${fns:escapeHtml(groomerDiploma.id)}">点击生成</a>
						</c:when>
						<c:when test="${not empty fns:escapeHtml(groomerDiploma.certificateCode)}">
							${fns:escapeHtml(groomerDiploma.certificateCode)}
						</c:when>
					</c:choose>
				</td>
				<td>
					<c:if test="${groomerDiploma.reviewState=='1' && empty groomerDiploma.issueDate }">
						<a href="${ctx}/groomer/groomerDiploma/createCodeOne?id=${fns:escapeHtml(groomerDiploma.id)}">点击生成</a>
					</c:if>
					<c:if test="${not empty groomerDiploma.issueDate}">
						<fmt:formatDate value="${groomerDiploma.issueDate}" pattern="yyyy-MM-dd"/>
					</c:if>
				</td>
				</shiro:hasPermission>
				<td>
					<c:choose>
						<c:when test="${groomerDiploma.paymentState=='1'}">
							<a onclick="util.pay('${fns:escapeHtml(groomerDiploma.id)}','groomer_diploma@F',1,'','${fns:escapeHtml(groomerDiploma.memberCode)}')">
								<font color="red">${fns:getDictLabel(groomerDiploma.paymentState,'user_payment_state','')}</font>
							</a>
						</c:when>
						<c:when test="${groomerDiploma.paymentState=='2'}">
							<font color="green">${fns:getDictLabel(groomerDiploma.paymentState, 'user_payment_state', '')}</font>
						</c:when>
					</c:choose>
				</td>
				<td>
					<shiro:hasPermission name="groomer:groomerDiploma:view">
						<a href="${ctx}/groomer/groomerDiploma/view?id=${groomerDiploma.id}">查看</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="groomer:groomerDiploma:edit">
						<a href="${ctx}/groomer/groomerDiploma/form?id=${groomerDiploma.id}">编辑</a>
					</shiro:hasPermission>
				</td>
				<td>
					<shiro:hasPermission name="groomer:groomerDiploma:audit">
					<c:choose>
						<c:when test="${groomerDiploma.reviewState=='0' }">
							<a href="${ctx}/groomer/groomerDiploma/review?id=${groomerDiploma.id}">未审核</a>
						</c:when>
						<c:when test="${groomerDiploma.reviewState=='2' }">
							<a style="color:red" title="${fns:escapeHtml(groomerDiploma.reviewRemarks)}">
							${fns:getDictLabel(groomerDiploma.reviewState, 'diploma_review_state', '')}
							</a>
						</c:when>
						<c:otherwise>
							<font color="green">${fns:getDictLabel(groomerDiploma.reviewState, 'diploma_review_state', '')}</font>
						</c:otherwise>
					</c:choose>
				</shiro:hasPermission>
				</td>
				<td>
					<shiro:hasPermission name="groomer:groomerDiploma:print">
					<c:if test="${groomerDiploma.printState=='0' && groomerDiploma.reviewState=='1' && groomerDiploma.paymentState=='2'&&not empty groomerDiploma.certificateCode}">
						<a href="${ctx}/groomer/groomerDiploma/groomerDiplomaPrint?id=${groomerDiploma.id}">打印</a>&nbsp;&nbsp;
					</c:if>
					</shiro:hasPermission>
					<shiro:hasPermission name="groomer:groomerDiploma:resetPrint">
					<c:if test="${groomerDiploma.printState=='1' }">
						<a style="color:red;" href="${ctx}/groomer/groomerDiploma/resetPrint?id=${groomerDiploma.id}">重置</a>&nbsp;&nbsp;
					</c:if>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>