<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>底部信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });

        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/gcWeb/footer/">底部信息列表</a></li>
    <shiro:hasPermission name="gcWeb:footer:add">
        <li><a href="${ctx}/gcWeb/footer/form">底部信息添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="gcWebFooter" action="${ctx}/gcWeb/footer/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label style="width: 40px">标题：</label>
            <form:input path="title" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>标题</th>
        <th>地址</th>
        <th>客服电话</th>
        <th>邮编</th>
        <th>邮箱</th>
        <th>操作</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="gcWebFooter">
        <tr>
            <td>
                    ${gcWebFooter.title}
            </td>
            <td>
                    ${gcWebFooter.address}
            </td>
            <td>
                    ${gcWebFooter.mobile}
            </td>
            <td>
                    ${gcWebFooter.postCode}
            </td>
            <td>
                    ${gcWebFooter.email}
            </td>
            <td>
                <shiro:lacksPermission name="gcWeb:footer:edit">
                    <a href="${ctx}/gcWeb/footer/form?id=${gcWebFooter.id}">查看</a>
                </shiro:lacksPermission>
                <shiro:hasPermission name="gcWeb:footer:edit">
                    <a href="${ctx}/gcWeb/footer/form?id=${gcWebFooter.id}">修改</a>
                </shiro:hasPermission>
                <shiro:hasPermission name="gcWeb:footer:del">
                    <a href="${ctx}/gcWeb/footer/delete?id=${gcWebFooter.id}"
                       onclick="return confirmx('确认要删除该美容官网底部信息吗？', this.href)">删除</a>
                </shiro:hasPermission>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>