<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>业务扣费</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
	function mySubmit()
	{	
		document.getElementById("isOnSubmit").value = "1";
		document.getElementById("searchForm").submit();
	}

	function SubmitByDate(date)
	{
		document.getElementById("isOnSubmit").value = "1";
		document.getElementById("nowDate").value=date;
		document.getElementById("searchForm").submit();
	}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">		
		<li class="active"><a href="#">业务扣费</a></li>
	</ul>
	<form id="searchForm"  action="${ctx}/finance/statistics/charge" method="post" class="breadcrumb form-search">		
		<ul class="ul-form">				
			<li class="btns"><input id="btnSubmit_current_month" class="btn btn-primary" type="button" value="本月" onclick="SubmitByDate('month')"/></li>
			<li class="btns"><input id="btnSubmit_current_yearh" class="btn btn-primary" type="button" value="本年" onclick="SubmitByDate('year')"/></li>
			<li><input id="nowDate" type="hidden" name="nowDate" value=""/></li>
			<li><input id="isOnSubmit" type = "hidden" name = "isOnSubmit" value = ""/></li>
			<li><label>开始时间：</label>
				<input id="startDate" style="width:160px;" name="startDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate"
				value="${startDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</li>
			<li><label style="width:100px;">结束时间：</label>
				<input id="endDate" style="width:160px;" name="endDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate"
				value="${endDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</li>
			<input type="hidden" id="officeNo" name="officeNo" value="${officeNo}"/>

			<li class="btns"><input id="btnSubmit" name="btnSubmit" class="btn btn-primary" type="submit" value="查询" onClick="mySubmit"/></li>
			<li class="clearfix"></li>
		</ul>		
	</form>
	<c:forEach items="${chargeDetails}" var="chargeDetails">
	<c:if test="${chargeDetails.officeName!='财务部' && chargeDetails.officeName!='合作单位'}">
	<hr style="align:center;height:2px;border:none;border-top:2px groove skyblue;" />
	<p style="text-align:left;font-size:18px;line-height:30px;"><b style="color:#9999ff;">${chargeDetails.officeName}</b><b>业务扣费统计</b></p>	
	<table id="${chargeDetails.officeName}" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>收费项目(价格)</th>
				<th colspan="2">合作机构</th>				
				<th colspan="2">会员中心</th>
				<th colspan="2">业务订单</th>
				<th colspan="2">OA扣费</th>
				<th>总数</th>
				<th>总金额（元）</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${chargeDetails.chargeItem}" var="chargeItem">
			<tr>
				<td>${fns:escapeHtml(chargeItem.chargeItem)}</td>
				<c:choose>
					<c:when test="${chargeItem.corpNum==0}">
						<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.corpNum)}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
					</c:when>
					<c:otherwise>
						<td><a href="${ctx}/finance/statistics/orderList?paymentState=2&startDate=${startDate}&endDate=${endDate}&orderType=corp&chargingItemID=${fns:escapeHtml(chargeItem.chargeID)}"><fmt:formatNumber value="${fns:escapeHtml(chargeItem.corpNum)}" pattern="#,##0.00#" maxFractionDigits="0"/></a></td>
					</c:otherwise>
				</c:choose>
				<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.corpFee)}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
				<c:choose>
					<c:when test="${chargeItem.memberNum==0}">
						<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.memberNum)}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
					</c:when>
					<c:when test="${fn:contains(showChargeItemID,chargeItem.chargeID)}">
						<td><a href="${ctx}/statistics/activity/showOrderList?paymentState=2&startDate=${startDate}&endDate=${endDate}&orderType=member&chargingItemID=${fns:escapeHtml(chargeItem.chargeID)}"><fmt:formatNumber value="${fns:escapeHtml(chargeItem.memberNum)}" pattern="#,##0.00#" maxFractionDigits="0"/></a></td>	
					</c:when>
					<c:otherwise>
						<td><a href="${ctx}/finance/statistics/orderList?paymentState=2&startDate=${startDate}&endDate=${endDate}&orderType=member&chargingItemID=${fns:escapeHtml(chargeItem.chargeID)}"><fmt:formatNumber value="${fns:escapeHtml(chargeItem.memberNum)}" pattern="#,##0.00#" maxFractionDigits="0"/></a></td>
					</c:otherwise>
				</c:choose>
				<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.memberFee)}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
				<c:choose>
					<c:when test="${chargeItem.orderNum==0}">
						<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.orderNum)}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
					</c:when>
					<c:otherwise>
						<td><a href="${ctx}/finance/statistics/orderList?paymentState=2&startDate=${startDate}&endDate=${endDate}&orderType=order&chargingItemID=${fns:escapeHtml(chargeItem.chargeID)}"><fmt:formatNumber value="${fns:escapeHtml(chargeItem.orderNum)}" pattern="#,##0.00#" maxFractionDigits="0"/></a></td>
					</c:otherwise>
				</c:choose>
				<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.orderFee)}" pattern="#,##0.00#" maxFractionDigits="2"/></td>				
				<c:choose>
					<c:when test="${chargeItem.OANum==0}">
						<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.OANum)}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
					</c:when>
					<c:otherwise>
						<td><a href="${ctx}/finance/memberAccount?paymentTimeStart=${startDate}&paymentTimeEnd=${endDate}&chargingItemId=${fns:escapeHtml(chargeItem.chargeID)}"><fmt:formatNumber value="${fns:escapeHtml(chargeItem.OANum)}" pattern="#,##0.00#" maxFractionDigits="0"/></a></td>
					</c:otherwise>
				</c:choose>
				<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.OAFee)}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
				<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.countNum)}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
				<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.countFee)}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
			</tr>		
		</c:forEach>
		</tbody>
		<tbody>
			<tr>
				<td><b>合计</b></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.countCoreNum}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.countCoreFee}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.countMemberNum}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.countMemberFee}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.countOrderNum}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.countOrderFee}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.countOANum}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.countOAFee}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.totalCountNum}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.totalCountFee}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
			</tr>
		</tbody>
		<tbody>
		
			<tr>
    			<td style="text-align:right;" colspan="11" valign="top" style="padding: 0;">
									<strong style="font-size:12px;display: inline-block;">${startDate}至${endDate} 共计：</strong>
    								<span style="font-size:20px; color: #9999ff;"><fmt:formatNumber type="currency" value="${chargeDetails.totalCount.totalCountFee}" maxFractionDigits="2"/></span>
    								<strong style="font-size:20px;display: inline-block;">元</strong>
    				
				</td>
    		</tr>
		</tbody>
	</table>
	</c:if>
	</c:forEach>
	<hr style="align=center;height:2px;border:none;border-top:2px groove skyblue;" />
	<p style="text-align: right;">
		<strong style="font-size:24px;display: inline-block;">${startDate}至${endDate} 业务扣费合计：</strong>
		<span style="font-size:32px; color: #9999ff;"><fmt:formatNumber type="currency" value="${chargeTotal}" maxFractionDigits="2"/></span>
		<strong style="font-size:24px;display: inline-block;">元</strong>
	</p>
	<c:forEach items="${chargeDetails}" var="chargeDetails">
	<c:if test="${chargeDetails.officeName=='财务部' || chargeDetails.officeName=='合作单位'}">
	<hr style="align=center;height:2px;border:none;border-top:2px groove skyblue;" />
	<p style="text-align:left;font-size:18px;line-height:30px;"><b style="color:#9999ff;">${chargeDetails.officeName}</b><b>业务扣费统计</b></p>	
	<table id="${chargeDetails.officeName}" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>收费项目(价格)</th>
				<th colspan="2">合作机构</th>				
				<th colspan="2">会员中心</th>
				<th colspan="2">业务订单</th>
				<th colspan="2">OA扣费</th>
				<th>总数</th>
				<th>总金额（元）</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${chargeDetails.chargeItem}" var="chargeItem">
			<tr>
				<td>${fns:escapeHtml(chargeItem.chargeItem)}</td>
				<c:choose>
					<c:when test="${chargeItem.corpNum==0}">
						<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.corpNum)}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
					</c:when>
					<c:otherwise>
						<td><a href="${ctx}/finance/statistics/orderList?paymentState=2&startDate=${startDate}&endDate=${endDate}&orderType=corp&chargingItemID=${fns:escapeHtml(chargeItem.chargeID)}"><fmt:formatNumber value="${fns:escapeHtml(chargeItem.corpNum)}" pattern="#,##0.00#" maxFractionDigits="0"/></a></td>
					</c:otherwise>
				</c:choose>
				<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.corpFee)}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
				<c:choose>
					<c:when test="${chargeItem.memberNum==0}">
						<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.memberNum)}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
					</c:when>
					<c:when test="${fn:contains(showChargeItemID,chargeItem.chargeID)}">
						<td><a href="${ctx}/statistics/activity/showOrderList?paymentState=2&startDate=${startDate}&endDate=${endDate}&orderType=member&chargingItemID=${fns:escapeHtml(chargeItem.chargeID)}"><fmt:formatNumber value="${fns:escapeHtml(chargeItem.memberNum)}" pattern="#,##0.00#" maxFractionDigits="0"/></a></td>	
					</c:when>
					<c:otherwise>
						<td><a href="${ctx}/finance/statistics/orderList?paymentState=2&startDate=${startDate}&endDate=${endDate}&orderType=member&chargingItemID=${fns:escapeHtml(chargeItem.chargeID)}"><fmt:formatNumber value="${fns:escapeHtml(chargeItem.memberNum)}" pattern="#,##0.00#" maxFractionDigits="0"/></a></td>
					</c:otherwise>
				</c:choose>
				<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.memberFee)}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
				<c:choose>
					<c:when test="${chargeItem.orderNum==0}">
						<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.orderNum)}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
					</c:when>
					<c:otherwise>
						<td><a href="${ctx}/finance/statistics/orderList?paymentState=2&startDate=${startDate}&endDate=${endDate}&orderType=order&chargingItemID=${fns:escapeHtml(chargeItem.chargeID)}"><fmt:formatNumber value="${fns:escapeHtml(chargeItem.orderNum)}" pattern="#,##0.00#" maxFractionDigits="0"/></a></td>
					</c:otherwise>
				</c:choose>
				
				<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.orderFee)}" pattern="#,##0.00#" maxFractionDigits="2"/></td>				
				<c:choose>
					<c:when test="${chargeItem.OANum==0}">
						<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.OANum)}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
					</c:when>
					<c:otherwise>
						<td><a href="${ctx}/finance/memberAccount?paymentTimeStart=${startDate}&paymentTimeEnd=${endDate}&chargingItemId=${fns:escapeHtml(chargeItem.chargeID)}"><fmt:formatNumber value="${fns:escapeHtml(chargeItem.OANum)}" pattern="#,##0.00#" maxFractionDigits="0"/></a></td>
					</c:otherwise>
				</c:choose>
				<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.OAFee)}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
				<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.countNum)}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
				<td><fmt:formatNumber value="${fns:escapeHtml(chargeItem.countFee)}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
			</tr>		
		</c:forEach>
		</tbody>
		<tbody>
			<tr>
				<td><b>合计</b></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.countCoreNum}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.countCoreFee}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.countMemberNum}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.countMemberFee}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.countOrderNum}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.countOrderFee}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.countOANum}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.countOAFee}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.totalCountNum}" pattern="#,##0.00#" maxFractionDigits="0"/></td>
				<td><fmt:formatNumber value="${chargeDetails.totalCount.totalCountFee}" pattern="#,##0.00#" maxFractionDigits="2"/></td>
			</tr>
		</tbody>
		<tbody>
		
			<tr>
    			<td style="text-align:right;" colspan="11" valign="top" style="padding: 0;">
									<strong style="font-size:12px;display: inline-block;">${startDate}至${endDate} 共计：</strong>
    								<span style="font-size:20px; color: #9999ff;"><fmt:formatNumber type="currency" value="${chargeDetails.totalCount.totalCountFee}" maxFractionDigits="2"/></span>
    								<strong style="font-size:20px;display: inline-block;">元</strong>
    				
				</td>
    		</tr>
		</tbody>
	</table>
	</c:if>
	</c:forEach>
</body>
</html>