<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>鼻纹识别登记管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/dog/dogNoseCheckin/">鼻纹识别登记列表</a></li>
		<li class="active"><a href="${ctx}/dog/dogNoseCheckin/form?id=${dogNoseCheckin.id}">鼻纹识别登记<shiro:hasPermission name="dog:dogNoseCheckin:edit">${not empty dogNoseCheckin.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="dog:dogNoseCheckin:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="dogNoseCheckin" action="${ctx}/dog/dogNoseCheckin/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">业务ID：</label>
			<div class="controls">
				<form:input path="bizId" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">业务类型 10：出生纸，20：血统证书，30：血统证书整窝，40：犬只补录：</label>
			<div class="controls">
				<form:input path="bizType" htmlEscape="false" maxlength="10" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">鼻纹ID：</label>
			<div class="controls">
				<form:input path="noseId" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">鼻纹编号：</label>
			<div class="controls">
				<form:input path="noseCode" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">设备号 HONORMOA-AL20,MT162CH/A：</label>
			<div class="controls">
				<form:input path="deviceNumber" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">设备平台 例如 Android IOS：</label>
			<div class="controls">
				<form:input path="devicePlatform" htmlEscape="false" maxlength="32" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">设备型号 例如：Android：MOA-AL20；IOS：iPhone XS，iPhone XR：</label>
			<div class="controls">
				<form:input path="deviceModel" htmlEscape="false" maxlength="32" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">设备系统版本 例如：Android：29，30；IOS：13.1，14.2：</label>
			<div class="controls">
				<form:input path="deviceVersion" htmlEscape="false" maxlength="32" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">设备其他信息：</label>
			<div class="controls">
				<form:input path="deviceInformation" htmlEscape="false" maxlength="256" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">操作人ID：</label>
			<div class="controls">
				<form:input path="operatorId" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">操作人编号：</label>
			<div class="controls">
				<form:input path="operatorCode" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">操作时间：</label>
			<div class="controls">
				<input name="operatorTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${dogNoseCheckin.operatorTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">登记状态：</label>
			<div class="controls">
				<form:input path="checkinStatus" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">登记失败原因：</label>
			<div class="controls">
				<form:input path="checkinFailReason" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">通知时间：</label>
			<div class="controls">
				<input name="notifyTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${dogNoseCheckin.notifyTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="dog:dogNoseCheckin:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>