<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只信息管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
            $("#btnImport").click(function(){
                $.jBox($("#importBox").html(), {title:"犬只导入", buttons:{"关闭":true},
                    bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
            });

            //显示导入错误提示
            var importError = "${importError}";
            var reg = new RegExp("##", "g")
            if (importError != null && importError != '' && typeof importError != 'undefined') {
                alert(importError.replace(reg, "\n"));
            }
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }

		function dogChipNoSwapForm() {
			parent.layer.open({
				type: 2,
				title: ['芯片号对调 ', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['600px', '350px'],
				content: ctx + "/dog/dog/chipNoSwapForm",
				end: function () {
					if (parent.isYes) {
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					}
				}
			});
		}
	</script>
</head>
<body>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/dog/dog/import" method="post" enctype="multipart/form-data"
			  class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
			<a href="${ctx}/dog/dog/import/template">下载模板</a>
		</form>
	</div>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dog/dog/">犬只信息列表</a></li>
		<shiro:hasPermission name="dog:dog:add"><li><a href="${ctx}/dog/dog/form">犬只信息添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="dog" action="${ctx}/dog/dog/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
		    <li><label>证书号/芯片号：</label>
                <form:input path="pedigreeCertifiedCode" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
		    <li><label>宠爱护照号：</label>
                <form:input path="cabPassportLike" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
            <li><label>国外证书号：</label>
                <form:input path="pedigreeCertifiedEn" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
			<li><label>英文姓名：</label>
				<form:input path="nameEn" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>出生日期：</label>
				<input name="birthdate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dog.birthdate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>图片审核：</label>
				<form:select path="pictureReviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="0" label="待审核"/>
					<form:option value="1" label="通过"/>
					<form:option value="2" label="未通过"/>
				</form:select>
			</li>
			<li><label>出生纸编号：</label>
				<form:input path="birthCertificateLevelCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>犬主人/会员号：</label>
				<form:input path="dogOwner" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>父血统证书号：</label>
				<form:input path="fdogPedigreeCertified" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>母血统证书号：</label>
				<form:input path="mdogPedigreeCertified" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>种类：</label>
				<form:input path="dogBreed" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>犬只状态：</label>
                <form:select path="dogState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('dogState')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
			<li><label>DNA留存方式：</label>
                <form:select path="dnaSaveWay" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('dna_save_way')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
			<li><label>犬只代数：</label>
				<form:input path="dogGeneration" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
			<li><label>双亲比对：</label>
                <form:select path="isDnaParentsCompare" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:option value="1" label="是"/>
                    <form:option value="0" label="否"/>
                </form:select>
            </li>
			<li><label>金质证书状态：</label>
				<form:select path="goldCertifiedState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('gold_certified_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>采样包编号：</label>
				<form:input path="samplingCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<%--<li><label>鼻纹状态：</label>--%>
                <%--<form:select path="noseFlag" class="input-medium">--%>
                    <%--<form:option value="" label="全部"/>--%>
                    <%--<form:option value="1" label="已采集"/>--%>
                    <%--<form:option value="0" label="未采集"/>--%>
                <%--</form:select>--%>
            <%--</li>--%>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<shiro:hasPermission name="dog:dog:import">
				<li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="导入犬只信息"/></li>
			</shiro:hasPermission>
			<shiro:hasPermission name="dog:dog:chipNoSwap">
				<li class="btns"><input id="btnChipNoSwap" class="btn btn-primary" onclick="dogChipNoSwapForm()" type="button" value="芯片号对调"/></li>
			</shiro:hasPermission>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>血统证书号</th>
				<th>性别</th>
				<th>英文姓名</th>
				<th>种类</th>
				<th>出生日期</th>
				<th>毛色</th>
				<th>芯片号</th>
				<th>宠爱护照号</th>
				<th>DNA留存方式</th>
				<th>金质证书状态</th>
				<th>采样包编号</th>
				<th>双亲比对</th>
				<th>犬主人</th>
				<th>犬只代数</th>
				<th>证书类型</th>
				<th>鼻纹状态</th>
				<th>图片审核</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dog">
			<tr>
				<td><a target="_blank" href="${dogInfoURL}${dog.pedigreeCertifiedCode}">
					${fns:desensitize(dog.pedigreeCertifiedCode,1) }
				</a></td>
				<td>
					${fns:getDictLabel(dog.gender, 'dog_gender', '')}
				</td>
				<td>
					${fns:escapeHtml(dog.nameEn)}
				</td>
				<td>
					${fns:escapeHtml(dog.dogBreed) }
				</td>
				<td>
					<fmt:formatDate value="${dog.birthdate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:escapeHtml(dog.colorFlag) }
				</td>
				<td>
					${fns:desensitize(dog.identificationFlag,2) }
				</td>
				<td>
					${fns:desensitize(dog.cabPassport,3) }
				</td>
				<td>
						${fns:getDictLabel(dog.dnaSaveWay, 'dna_save_way', '')}
				</td>
				<td>
						${fns:getDictLabel(dog.goldCertifiedState, 'gold_certified_state', '')}
				</td>
				<td>
						${fns:escapeHtml(dog.samplingCode) }
				</td>
				<td>
					<c:if test="${dog.isDnaParentsCompare=='1'}">是</c:if>
				</td>
				<td title="${fns:escapeHtml(dog.memberCode)}">
					${fns:escapeHtml(dog.dogOwner)}
					<c:if test="${dog.secondDogOwner!=''&&dog.secondDogOwner!=null}">/${fns:escapeHtml(dog.secondDogOwner) }</c:if>
				</td>
				<td>
				    ${fns:escapeHtml(dog.dogGeneration) }
				</td>
				<td>
					<c:if test="${dog.ecertFlag == '0'}">
						纸质版
					</c:if>
					<c:if test="${dog.ecertFlag == '1'}">
						电子版
					</c:if>
				</td>
				<td>
					<c:if test="${empty dog.noseFlag}">
						未采集
					</c:if>
					<c:if test="${not empty dog.noseFlag}">
						已采集
					</c:if>
				</td>
				<td>
					<c:if test="${dog.picture !=null}">
						<a href="${ctx}/dog/dog/reviewPicture?id=${dog.id}">${fns:getDictLabel(dog.pictureReviewState, 'review_state', '')}</a>
					</c:if>
					<c:if test="${empty dog.picture}">
						--
					</c:if>
				</td>
				<td>
				<shiro:hasPermission name="dog:dog:view">
                    <a href="${ctx}/dog/dog/view?id=${dog.id}">查看</a>
                </shiro:hasPermission>
				<shiro:hasPermission name="dog:dog:edit">
    				<a href="${ctx}/dog/dog/form?id=${dog.id}">编辑</a>
    			</shiro:hasPermission>

    			<c:if test="${dog.ecertFlag == '0'}">

    				<shiro:hasPermission name="dog:dog:print">
	    			<c:if test="${dog.printState=='1'}"><a onclick="print('${ctx}/dog/dog/print?id=${dog.id}');" href="###">鉴定证书打印</a></c:if>
	    			<c:if test="${dog.printState=='2'}"><a onclick="print('${ctx}/dog/dog/print?id=${dog.id}');" href="###">血统证书打印</a></c:if>
	    			<c:if test="${dog.printState=='3'}"><a onclick="print('${ctx}/dog/dog/print?id=${dog.id}');" href="###">出口证书打印</a></c:if>
					</shiro:hasPermission>
	    			<shiro:hasPermission name="dog:dog:resetPrint">
	    				<c:if test="${fn:length(dog.printState)==2&&fn:startsWith(dog.printState,'0')}">
						<a href="###" onclick="resetPrint('${ctx}/dog/dog/resetPrint?id=${dog.id}');">重置打印</a>
						</c:if>
					</shiro:hasPermission>
				</c:if>
    			<shiro:hasPermission name="dog:dog:delete">
					<a href="${ctx}/dog/dog/delete?id=${dog.id}" onclick="return confirmx('确认要删除该犬只信息吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>