<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>DNA纯种犬证书打印</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript" src="${ctxStatic}/modules/common/LodopFuncs.js"></script>
	<object id="LODOP_OB" classid="clsid:2105C259-1E0C-4534-8141-A753534CB4CA" width=0 height=0>
  	<embed id="LODOP_EM" type="application/x-print-lodop" width=0 height=0 pluginspage="${ctxStatic}/modules/common/install_lodop.exe"></embed>
	</object>
	<script type="text/javascript">
		window.onload = function (){
			let geneCode = '${geneCode}';
			let colorList = ['188, 159, 233', '29, 207, 238', '127, 144, 254', '218, 140, 67', '127, 223, 114', '205, 91, 190', '109, 201, 217', '234, 85, 89', '34, 144, 140', '239, 217, 119', '177, 82, 87', '74, 183, 144', '86, 101, 155', '202, 47, 28', '35, 193, 43', '161, 80, 206', '39, 145, 255', '34, 221, 129', '0, 237, 255', '128, 188, 0', '40, 155, 192', '243, 122, 73', '181, 82, 77', '111, 74, 246', '53, 179, 200', '64, 117, 187']
			var c = document.getElementById("dnaCanvas");
			var ctx = c.getContext("2d");
			ctx.clearRect(0, 0, 0, 0);
			let n = 0
			let num = 26
			let width = 30
			let gene = geneCode.split('')
			for (let i = 0; i < num; i++) {
				for (let j = 0; j < 6; j++) {
					n += 1
					let t = gene[n];
					if (isNaN(t)) {
						t = j + 2
					}
					ctx.fillStyle = 'rgba(' + colorList[i] + ', ' + setOpactiy(t) + ')'
					ctx.fillRect(i * width, j * 14, width, 10);
				}
			}
			const shareImg = new Image();
			shareImg.crossOrigin = 'anonymous'
			document.getElementById('dnaImg').src = c.toDataURL("image/png")
		}

		function setOpactiy(n) {
			if (n == 0) {
				return 1
			} else {
				return '.' + (10 - n);
			}
		}

		function setGene(geneCode) {
			let gene = geneCode
			gene = gene.split('X##').join('244')
			gene = gene.split('Y##').join('255')
			gene = gene.split('###').join('369')
			return gene
		}

	    var LODOP;
	    var printLeftString = '${fns:getUser().printLeft}';
	    var printTopString = '${fns:getUser().printTop}';
	    var printLeft = parseInt(printLeftString);
	    var printTop = parseInt(printTopString)-70;


		/**
		 * 打印
		 * @param type 1为预览2为维护
		 */
	    function preparePrint(type) {
			createPage();
			LODOP.SET_PRINT_PAGESIZE(3,"210mm","297mm","A4");
			LODOP.SET_SHOW_MODE("BKIMG_IN_PREVIEW",1);
			LODOP.ADD_PRINT_SETUP_BKIMG("<img border='0' src='"+ctxStatic+"/modules/common/dna_appraisal_certificate.png' width='782px;' height='1113px;'>");
			if (type == 1) {
				LODOP.PREVIEW();
			} else if (type == 2) {
				LODOP.PRINT_SETUP();
			}
		}

		function createPage() {
			LODOP=getLodop(document.getElementById('LODOP_OB'),document.getElementById('LODOP_EM'));
			LODOP.PRINT_INITA(0,0,"210mm","297mm","DNA纯种犬证书打印");
			//设置默认字体样式：微软雅黑 9pt
			LODOP.SET_PRINT_STYLE("FontName","微软雅黑");
			LODOP.SET_PRINT_STYLE("FontSize",10);

			var dogName = '${fns:escapeEcmaScript(dog0.nameEn)}';
			var breedCnName = '${breedCnName}';
			var breedEnName = '${breedEnName}';
			var dogGender = '${fns:getDictLabel(dog0.gender, "dog_gender", '')}';
			var birthday = '<fmt:formatDate value="${dog0.birthdate}" pattern="yyyy年M月d日"/>';
			var dogChip = '${dog0.identificationFlag}';
			var colorFlag = '${dog0.colorFlag}';
			var pedigreeCertified = '${dog0.pedigreeCertifiedCode}';
			var dogOwnerName = '${dogOwnerName}';
			var date='${date}';
			var geneCode = '${geneCode}';
			//打印内容
			LODOP.ADD_PRINT_TEXT(printTop+240,280+printLeft,250,20,dogName);
			LODOP.ADD_PRINT_TEXT(printTop+275,195+printLeft,250,20,breedCnName);
			LODOP.ADD_PRINT_TEXT(printTop+275,520+printLeft,250,20,breedEnName);
			LODOP.ADD_PRINT_TEXT(printTop+300,195+printLeft,250,20,dogGender);
			LODOP.ADD_PRINT_TEXT(printTop+300,520+printLeft,250,20,birthday);
			LODOP.ADD_PRINT_TEXT(printTop+330,195+printLeft,250,20,dogChip);
			LODOP.ADD_PRINT_TEXT(printTop+330,520+printLeft,250,20,colorFlag);
			LODOP.ADD_PRINT_TEXT(printTop+355,195+printLeft,250,20,dogOwnerName);
			LODOP.ADD_PRINT_TEXT(printTop+355,520+printLeft,250,20,pedigreeCertified);
			//dna编号
			if (geneCode != "") {
				LODOP.ADD_PRINT_IMAGE(370, 260, 300, 80, "<img  src='" + document.getElementById('dnaImg').src + "' width='300px;' height='80px;' />");
			}
			LODOP.ADD_PRINT_IMAGE(printTop+945,200+printLeft,120,90,"<img style='z-index:-1;' transcolor='#FFFFFF' src='"+ctxStatic+"/modules/common/appraisal_chairman_signature_new.png' width='110px;' height='75px;'>");
			LODOP.ADD_PRINT_TEXT(printTop+965,520+printLeft,250,20,date);
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active">DNA纯种犬证书打印</li>
	</ul><br/>
	<input type="button" value="打印" onclick="preparePrint(1)"/>
	<input type="button" value="打印维护" onclick="preparePrint(2)"/>

	<p id="tt01">请使用A4打印机打印！下图为证书样本。</p>
	<p>
	<img src="${ctxStatic}/modules/common/dna_appraisal_certificate.png" width="782" height="1113" title="证书正面" style="border:#CCC 1px solid; margin-top:10px;"/></p>
	<canvas id="dnaCanvas" height="100px" width="800px" style="display: none"></canvas>
	<img id="dnaImg" src="" alt="" style="display: none">
	<div class="form-actions">
         <input id="btnCancel" class="btn" type="button" value="返 回" onclick="go()"/>
        <script type="text/javascript">
        	function go(){
        		location.href = document.referrer;
        	}
        </script>
    </div>
</body>
</html>