<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>广告位管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/banner/appBanner/">广告位列表</a></li>
		<shiro:hasPermission name="banner:appBanner:add"><li><a href="${ctx}/banner/appBanner/form">广告位添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="appBanner" action="${ctx}/banner/appBanner/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>广告名称：</label>
				<form:input path="bannerName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>广告位置：</label>
				<form:select path="bannerPlace" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="1" label="首页_H1_强力推荐"/>
					<form:option value="2" label="首页_H1_热门犬舍"/>
					<form:option value="3" label="首页_H1_犬舍联盟"/>
				</form:select>
			</li>
			<li><label>广告状态：</label>
				<form:select path="bannerTimeStatus" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="1" label="未开始"/>
					<form:option value="2" label="进行中"/>
					<form:option value="3" label="已结束"/>
				</form:select>
			</li>
			
			<li><label>启用状态：</label>
				<form:select path="bannerStatus" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="0" label="启用"/>
					<form:option value="1" label="禁用"/>
				</form:select>
			</li>
			<li><label>犬舍编号：</label>
				<form:input path="kennelCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			
			<li><label>广告时间：</label>
				<input name=start type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${appBanner.start}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
					 至：
					<input name=end type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${appBanner.end}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li> 
			<li><label>创建时间：</label>
				<input name=createDate type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${appBanner.createDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li> 
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>排序</th>
				<th>广告位置</th>
				<th>链接类型</th>
				<th>广告名称</th>
				<th>链接数据</th>
				<th>状态</th>
				<th>启用状态</th>
				<th>广告时间</th>
				<th>创建时间</th>
				<shiro:hasPermission name="banner:appBanner:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="appBanner">
			<tr>
				<td>
					${fns:escapeHtml(appBanner.bannerSort)}
				</td>
				<td>
					<c:if test="${appBanner.bannerPlace=='1'}">首页_H1_强力推荐</c:if>
					<c:if test="${appBanner.bannerPlace=='2'}">首页_H1_热门犬舍</c:if>
					<c:if test="${appBanner.bannerPlace=='3'}">首页_H1_犬舍联盟</c:if>
				</td>
				<td>
					<c:if test="${appBanner.bannerType=='1'}">app原生</c:if>
				</td>
				<td>
					${fns:escapeHtml(appBanner.bannerName)}
				</td>
				<td>
					${fns:escapeHtml(appBanner.kennelCode)}
				</td>
				<!-- 状态 -->
				<td>
					${fns:escapeHtml(appBanner.bannerTimeStatusDesc)}
				</td>
				<!-- 启用状态 -->
				<td>
					<c:if test="${appBanner.bannerStatus == '0'}">启用</c:if>
					<c:if test="${appBanner.bannerStatus == '1'}">禁用</c:if>
				</td>
				<td>
					<fmt:formatDate value="${appBanner.startDate}" pattern="yyyy-MM-dd"/> ～ 
					<fmt:formatDate value="${appBanner.endDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${appBanner.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<shiro:hasPermission name="banner:appBanner:edit"><td>
    				<a href="${ctx}/banner/appBanner/form?id=${appBanner.bannerId}">${appBanner.id}编辑</a>
    				
    				<c:if test="${ appBanner.bannerTimeStatusDesc eq '已结束' }">
    					<a href="${ctx}/banner/appBanner/delete?id=${appBanner.bannerId}" onclick="return confirmx('确认要删除该广告位吗？', this.href)">删除</a>
    				</c:if>
    				
    				<c:if test="${ appBanner.bannerStatus == '0'}">
    					<a href="${ctx}/banner/appBanner/endBanner?id=${appBanner.bannerId}" onclick="return confirmx('确认要禁用该广告位吗？', this.href)">${appBanner.id}禁用</a>
    				</c:if>
					<c:if test="${ appBanner.bannerStatus == '1'}">
    					<a href="${ctx}/banner/appBanner/startBanner?id=${appBanner.bannerId}" onclick="return confirmx('确认要启用该广告位吗？', this.href)">${appBanner.id}启用</a>
    				</c:if>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>s