package com.ufida.api.service;

import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.ufida.api.request.CustomerAddRequest;
import com.ufida.api.response.UfidaSyncResponse;
import com.ufida.api.vo.CustomerVo;
import com.ufida.api.vo.FitemVo;

import openapi4j.exception.OpenAPIException;
import openapi4j.service.CustomerService;
import openapi4j.service.FitemService;

@Service
public class UfidaBaseInfoSyncService {
	
	public UfidaSyncResponse syncProject(FitemVo item) {
		
		FitemService service = new FitemService();
		try {
			Map<String,Object> params = new HashMap<>();
			params.put("fitem", item);
//			service.add(JSONObject.toJSONString(params), "ChongAiWG");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return new UfidaSyncResponse();
	} 
	
	public UfidaSyncResponse syncCustomer(CustomerVo customer) {
		
		CustomerService service = new CustomerService();
		try {
			CustomerAddRequest request = new CustomerAddRequest(customer);
			service.add(JSONObject.toJSONString(request), "ChongAiWG");
		} catch (OpenAPIException e) {
			e.printStackTrace();
		}
		return new UfidaSyncResponse();
	} 
	

}
