package com.cku.restful.v1.show.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.show.dao.ShowResultsDao;
import com.cku.oa.show.dao.ShowScoreDao;
import com.cku.oa.show.dao.ShowScoreTitleDao;
import com.cku.oa.show.entity.ShowResults;
import com.cku.oa.show.entity.ShowScore;
import com.cku.oa.show.entity.ShowScoreRanking;
import com.cku.oa.show.entity.ShowScoreTitle;
import com.cku.oa.show.service.ShowScoreRankingService;
import com.cku.restful.v1.show.model.CkuShowScore;
import com.cku.restful.v1.show.model.CkuShowScoreLunbo;
import com.cku.restful.v1.show.service.APPShowsService;
import com.cku.restful.v1.show.service.CKUShowReportInfoService;
import com.cku.restful.v1.show.service.CkuShowsService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.common.utils.DateUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

@Controller
@RequestMapping(value = "/app/v1/shows")
@Api(tags = "APP犬展接口--wj")
public class APPShowsController extends BaseRestController {

	@Autowired
	public APPShowsService appShowsService;
	@Autowired
	private ShowScoreDao showScoreDao;
	@Autowired
	private CKUShowReportInfoService showReportInfoService;
	@Autowired
	private ShowResultsDao showResultsDao;
	@Autowired
	private ShowScoreTitleDao showScoreTitleDao;
	@Autowired
	private ShowScoreRankingService showScoreRankingService;

	@Autowired
    public CkuShowsService restShowsService;
	/**
	 *
	 * @Description：app官网犬展回顾接口
	 * @author:
	 * @version:
	 * @throws IOException
	 */
	@RequestMapping(value = "/review", method = RequestMethod.GET)
	@ResponseBody
	public void review(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = appShowsService.review(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：根据主犬展查询子犬展
	 * @author:
	 * @version:
	 * @throws IOException
	 */
	@RequestMapping(value = "/getChildListByMainId", method = RequestMethod.GET)
	@ResponseBody
	public void getChildListByMainId(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = appShowsService.getChildListByMainId(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * app犬展裁判
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/getChildListInfoByMainId", method = RequestMethod.GET)
	@ResponseBody
	public void getChildListInfoByMainId(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = appShowsService.getChildListInfoByMainId(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * app获取赛程表
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/getcheduleImageByMainId", method = RequestMethod.GET)
	@ResponseBody
	public void getcheduleImageByMainId(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = new RESTResponse();
		try {
			result = appShowsService.getcheduleImageByMainId(request);
		} catch (Exception e) {
			result.setRc(1);
			result.setMsg(e.getMessage());
		}
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * app裁判信息详情
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/getShowJudgeInfo", method = RequestMethod.GET)
	@ResponseBody
	public void getShowJudgeInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = appShowsService.getShowJudgeInfo(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * app犬展成绩播报
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/getShowReportInfoById", method = RequestMethod.GET)
	@ResponseBody
	public void getShowReportInfoById(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String id = request.getParameter("id");//
		RESTResponse result = showReportInfoService.getShowReportInfoById(id);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "APP犬展积分榜")
	@ApiImplicitParams({ @ApiImplicitParam(name = "pageNo", paramType = "query", value = "页码"),
			@ApiImplicitParam(name = "pageSize", paramType = "query", value = "条数"),
			@ApiImplicitParam(name = "year", paramType = "query", value = "年份"),
			@ApiImplicitParam(name = "scoreType", paramType = "query", value = "积分类别：3成年犬组、20繁殖积分榜、ohc犬主人组、bbe繁殖人组"),
			@ApiImplicitParam(name = "pedigreeCertified", paramType = "query", value = "血统证书编号"),
			@ApiImplicitParam(name = "name", paramType = "query", value = "名称") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" + "  \"rc\": 0,\n" + "  \"msg\": \"OK\",\n"
			+ "  \"list\": [\n" + "    {\n" + "      \"pedigreeCertified\": \"CKU-85451010/18\",\n"
			+ "      \"score\": \"1305\",\n" + "      \"scoreType\": \"\",\n" + "      \"dogOwner\": \"陈智\",\n"
			+ "      \"kennlCnName\": \"老友犬舍\",\n" + "      \"dogBreedNameEn\": \"West Highland White Terrier\",\n"
			+ "      \"kennlEnName\": \"Polar Dancer's Kennel（FCI）\",\n" + "      \"dogBreedNameCn\": \"西高地白梗犬\",\n"
			+ "      \"dogName\": \"CN CH Polar Dancer Reign of hearts rc\"\n" + "    }\n" + "  ],\n"
			+ "  \"total\": 1\n" + "}") })
	@RequestMapping(value = "/score/rank", method = RequestMethod.GET)
	@ResponseBody
	public void getScore(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String year = request.getParameter("year");
		String name = request.getParameter("name");
		String scoreType = request.getParameter("scoreType");
		String pedigreeCertified = request.getParameter("pedigreeCertified");
		String pageSize = request.getParameter("pageSize");
		String pageNo = request.getParameter("pageNo");
		Integer pageSizeInt = null;
		Integer pageNoInt = null;
		if (StringUtils.isNotBlank(pageSize)) {
			try {
				pageSizeInt = Integer.valueOf(pageSize);
				pageNoInt = (Integer.valueOf(pageNo) - 1) * pageSizeInt;
			} catch (Exception e) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageSize必须为整数");
			}
		}
		String ageGroup = getAgeGroup(year, scoreType);
		List<ShowScore> showScoreList = null;
		List<ShowResults> resultsList = null;
		List pedigreeCertifiedList = new ArrayList();
		if ("2020".equals(year)) {
			pedigreeCertifiedList = showResultsDao.getDogAgeGroups();
		}
		if (StringUtils.isBlank(scoreType) || "1".equals(scoreType) || "2".equals(scoreType)) {
			showScoreList = showScoreDao.getScoreRank123(year, scoreType, pedigreeCertified, null, ageGroup, null);
		} else if ("3".equals(scoreType)) {
			showScoreList = showScoreDao.getScoreRank123(year, scoreType, pedigreeCertified, null, ageGroup,
					pedigreeCertifiedList);
		} else if ("20".equals(scoreType)) {
			showScoreList = showScoreDao.getScoreRank20(year, scoreType,  pedigreeCertified,null, pedigreeCertifiedList);
		} else if ("ohc".equals(scoreType)) {
			resultsList = showResultsDao.getOHCScore(year, name, pageSizeInt);
		} else if ("bbe".equals(scoreType)) {
			resultsList = showResultsDao.getBBEScore(year, name, pageSizeInt, null);
		}

		HashMap<String, Object> result = new HashMap<String, Object>();
		List<CkuShowScore> list = new ArrayList<CkuShowScore>();
		if (showScoreList != null && showScoreList.size() > 0) {
			for (ShowScore showScore : showScoreList) {
				list.add(new CkuShowScore(showScore));
			}
		}
		if (resultsList != null && resultsList.size() > 0) {
			for (ShowResults data : resultsList) {
				list.add(new CkuShowScore(data));
			}
		}
		long count = list.size();
		if (pageNoInt < list.size()) {
			if ((pageNoInt + pageSizeInt) < list.size()) {
				list = list.subList(pageNoInt, (pageNoInt + pageSizeInt));
			} else {
				list = list.subList(pageNoInt, list.size());
			}
		} else {
			list.clear();
		}
		result.put("list", list);
		result.put("total", count);
		result.put("scoreTitle", getScoreTitle(year, scoreType));
		ServletUtils.writeResponse(response, new RESTResponse("data", result));
	}

	@RequestMapping(value = "/lunbo", method = RequestMethod.GET)
	@ResponseBody
	public void lunbo(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String year = DateUtils.getYear();
//		赛季从每年十月份开始、不到十月份则取上一年的值
		int month = Integer.parseInt(DateUtils.getMonth());
		if (month < 10) {
			year = Integer.parseInt(year) - 1 + "";
		}

		ShowScoreRanking showScoreRanking = new ShowScoreRanking();
		showScoreRanking.setLimit(3);
		showScoreRanking.setScoreType("20");
		showScoreRanking.setYear(year);
		List<ShowScoreRanking> scoreRank123 = showScoreRankingService.findList(showScoreRanking);
		showScoreRanking.setScoreType("3");
		List<ShowScoreRanking> scoreRank20 = showScoreRankingService.findList(showScoreRanking);
		showScoreRanking.setScoreType("ohc");
		List<ShowScoreRanking> ohcScore = showScoreRankingService.findList(showScoreRanking);
		showScoreRanking.setScoreType("bbe");
		List<ShowScoreRanking> bbeScore = showScoreRankingService.findList(showScoreRanking);

		// 返回对象
		List<HashMap<String, Object>> list = new ArrayList<>();
		// 本土繁殖
		HashMap<String, Object> adultmap = new HashMap<String, Object>();
		List<CkuShowScoreLunbo> adultList = new ArrayList<CkuShowScoreLunbo>();
		if (scoreRank123 != null && scoreRank123.size() > 0) {
			for (ShowScoreRanking showScore : scoreRank123.subList(0, 3)) {
				showScore.setScoreType("adult");
				adultList.add(new CkuShowScoreLunbo(showScore));
			}
		}
		if (!CollectionUtils.isEmpty(adultList)) {
			adultmap.put("scoreType", "adult");
			adultmap.put("scoreTitle", getScoreTitle(year, "20"));
			adultmap.put("list", adultList);
			list.add(adultmap);
		}
		// 成年犬组
		HashMap<String, Object> mainlandmap = new HashMap<String, Object>();
		List<CkuShowScoreLunbo> mainlandList = new ArrayList<>();
		if (scoreRank123 != null && scoreRank20.size() > 0) {
			for (ShowScoreRanking showScore : scoreRank20.subList(0, 3)) {
				showScore.setScoreType("mainland");
				mainlandList.add(new CkuShowScoreLunbo(showScore));
			}
		}
		if (!CollectionUtils.isEmpty(mainlandList)) {
			mainlandmap.put("list", mainlandList);
			mainlandmap.put("scoreTitle", getScoreTitle(year, "3"));
			mainlandmap.put("scoreType", "mainland");
			list.add(mainlandmap);
		}
		// 繁殖人组
		HashMap<String, Object> bbemap = new HashMap<String, Object>();
		List<CkuShowScoreLunbo> bbeList = new ArrayList<>();
		if (!Collections3.isEmpty(bbeScore)) {
			if (bbeScore.size() >= 3) {
				bbeScore = bbeScore.subList(0, 3);
			}
			for (ShowScoreRanking data : bbeScore) {
				data.setScoreType("bbe");
				bbeList.add(new CkuShowScoreLunbo(data));
			}
		}
		if (!CollectionUtils.isEmpty(bbeList)) {
			bbemap.put("list", bbeList);
			bbemap.put("scoreTitle", getScoreTitle(year, "bbe"));
			bbemap.put("scoreType", "bbe");
			list.add(bbemap);
		}

		// 犬主人组
		HashMap<String, Object> ohcmap = new HashMap<String, Object>();
		List<CkuShowScoreLunbo> ohcList = new ArrayList<>();
		if (!Collections3.isEmpty(ohcScore)) {
			if (ohcScore.size() >= 3) {
				ohcScore = ohcScore.subList(0, 3);
			}
			for (ShowScoreRanking data : ohcScore) {
				data.setScoreType("ohc");
				ohcList.add(new CkuShowScoreLunbo(data));
			}
		}
		if (!CollectionUtils.isEmpty(ohcList)) {
			ohcmap.put("list", ohcList);
			ohcmap.put("scoreType", "ohc");
			ohcmap.put("scoreTitle", getScoreTitle(year, "ohc"));
			list.add(ohcmap);
		}

		ServletUtils.writeResponse(response, new RESTResponse("data", list));
	}

	private String getScoreTitle(String year, String scoreType) {
		ShowScoreTitle scoreTitle = showScoreTitleDao.getByYearAndGroup(year, scoreType);
		if (scoreTitle != null) {
			return scoreTitle.getTitle();
		} else {
			return "";
		}
	}

//	private List<ShowScore> getDogAgeGroups(List<ShowScore> showScoreList) {
//		List<ShowScore> list = new ArrayList<>();
//		for (ShowScore showScore : showScoreList) {
//			List ageGroups = showResultsDao.getDogAgeGroups(showScore.getPedigreeCertified());
//			if(ageGroups.contains("12") || ageGroups.contains("13") || ageGroups.contains("14")){
//				list.add(showScore);
//			}
//		}
//		return list;
//	}
	private String getAgeGroup(String year, String scoreType) {
		String result = "";
		if ("2013".equals(year) || "2014".equals(year) || "2015".equals(year) || "2016".equals(year)
				|| "2017".equals(year) || "2018".equals(year) || "2019".equals(year) || "2020".equals(year)
				|| "2021".equals(year)) {
			if ("1".equals(scoreType) || "8".equals(scoreType)) {
				result = "AND age_group IN (1,2)";
			}
			if ("2".equals(scoreType) || "7".equals(scoreType)) {
				result = "AND age_group IN (3,4)";
			}
			if ("6".equals(scoreType) || "30".equals(scoreType)) {
				result = "AND age_group > 4";
			}
			if ("3".equals(scoreType) || "20".equals(scoreType)) {
				if ("2020".equals(year)) {
					result = "AND (\n" + "\t\t\t(\n" + "\t\t\t\tsr.age_group IN ('12', '13', '14')\n"
							+ "\t\t\t\tAND scd.start_time >= '2020-05-01 00:00:00'\n" + "\t\t\t)\n"
							+ "\t\t\tOR scd.start_time < '2020-05-01 00:00:00'\n" + "\t\t)";
				} else {
					result = "AND age_group IN ('12','13','14')";
				}
			}
		} else {
			if ("1".equals(scoreType)) {
				result = "AND age_group < 5";
			}
			if ("2".equals(scoreType)) {
				result = "AND age_group >4";
			}
		}
		return result;
	}

	@RequestMapping(value = "/hotelInfo", method = RequestMethod.GET)
	@ResponseBody
	public void hotelInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restShowsService.hotelInfo(request);
		ServletUtils.writeResponse(response, result);
	}
}
