/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.show.model;

import java.text.SimpleDateFormat;

import org.apache.commons.lang3.StringUtils;

import com.cku.oa.show.entity.ShowResultsDdz;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

/**
 * 单独展赛事成绩Entity
 * 
 * @author lgl
 * @version 2016-07-21
 */
public class RestShowResultsDdz {
	private String referee; // 裁判
	private String ageGroup; // 年龄组别
	private String showResult; // 本场积分
	private String orderCode; // 秩序号
	private String resultCc; // cc项成绩
	private String rankings; // 小组排名
	private String startTime; // 开始时间
	private String endTime; // 结束时间
	private String showName; // 赛事名称
	private String resultBow; // BOW项成绩
	private String result; // 页面成绩项
	private String remarksCc; // CC备注

	public RestShowResultsDdz(ShowResultsDdz vo) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		if (vo.getStartTime() != null) {
			this.startTime = sdf.format(vo.getStartTime());
			if (vo.getEndTime() != null) {
				this.startTime = this.startTime + "/"
						+ sdf.format(vo.getEndTime()).substring(8);
			}
		}
		this.showName = vo.getShowName();
		this.orderCode = vo.getOrderCode();
		this.resultCc = vo.getResultCc();
		this.rankings = vo.getRankings();
		this.resultBow = vo.getResultBow();
		this.remarksCc = vo.getRemarksCc();
		if (StringUtils.isBlank(vo.getResultBiss())) {
			if (StringUtils.isBlank(vo.getResultBob())) {
				if (StringUtils.isNotBlank(vo.getResultWb())) {
					this.result = vo.getResultWb();
				}
			} else {
				this.result = vo.getResultBob();
			}
		} else {
			this.result = vo.getResultBiss();
		}
		this.showResult = (StringUtils.isNotBlank(vo.getShowResult())?vo.getShowResult():"0")+"/"+ (StringUtils.isNotBlank(vo.getShowBreedResult())?vo.getShowBreedResult():"0");
		this.ageGroup = DictUtils.getDictLabel(vo.getAgeGroup(),
				"show_age_group", "");
		this.referee = vo.getReferee();
		//如果cc成绩备注为成绩取消作为前缀，以下成绩不显示
		if(StringUtils.isNotBlank(vo.getRemarksCc())&&vo.getRemarksCc().startsWith("成绩取消")){
			this.resultCc = "";
			this.rankings = "";
			this.resultBow = "";
			this.result = "";
			this.showResult = "";
		}
	}

	public String getReferee() {
		return referee;
	}

	public void setReferee(String referee) {
		this.referee = referee;
	}

	public String getAgeGroup() {
		return ageGroup;
	}

	public void setAgeGroup(String ageGroup) {
		this.ageGroup = ageGroup;
	}

	public String getShowResult() {
		return showResult;
	}

	public void setShowResult(String showResult) {
		this.showResult = showResult;
	}

	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public String getResultCc() {
		return resultCc;
	}

	public void setResultCc(String resultCc) {
		this.resultCc = resultCc;
	}

	public String getRankings() {
		return rankings;
	}

	public void setRankings(String rankings) {
		this.rankings = rankings;
	}

	public String getStartTime() {
		return startTime;
	}

	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

	public String getEndTime() {
		return endTime;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	public String getShowName() {
		return showName;
	}

	public void setShowName(String showName) {
		this.showName = showName;
	}

	public String getResultBow() {
		return resultBow;
	}

	public void setResultBow(String resultBow) {
		this.resultBow = resultBow;
	}

	public String getResult() {
		return result;
	}

	public void setResult(String result) {
		this.result = result;
	}

	public String getRemarksCc() {
		return remarksCc;
	}

	public void setRemarksCc(String remarksCc) {
		this.remarksCc = remarksCc;
	}
}