package com.cku.restful.v1.open;

import com.cku.core.PageResultDto;
import com.cku.core.ResultDto;
import com.cku.oa.show.entity.ShowAdvisor;
import com.cku.oa.show.service.ShowAdvisorService;
import com.cku.oa.sys.util.ImgUtil;
import com.cku.restful.v1.show.request.ShowAdvisorDetailRequest;
import com.cku.restful.v1.show.request.ShowAdvisorPageRequest;
import com.cku.restful.v1.show.response.ShowAdvisorDetailResponse;
import com.cku.restful.v1.show.response.ShowAdvisorPageResponse;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.thinkgem.jeesite.common.beanvalidator.BeanValidators;
import com.thinkgem.jeesite.common.persistence.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 赛事顾问
 *
 * @author yuanshuai
 * @date 2025年7月2日14:18:07
 */
@Controller
@Api(tags = "赛事顾问")
@RequestMapping(value = "/api/v1/open/show/advisor")
public class OpenShowAdvisorController extends BaseRestController {

	@Autowired
	private ShowAdvisorService showAdvisorService;

	@ApiOperation(value = "分页")
	@GetMapping(value = "/list")
	@ResponseBody
	public PageResultDto<ShowAdvisorPageResponse> findPage(@Valid ShowAdvisorPageRequest request, HttpServletRequest httpRequest) {
		BeanValidators.validateWithException(validator, request);
		Page<ShowAdvisor> page = new Page<>();
		page.setPageNo(request.getPageNo());
		page.setPageSize(request.getPageSize());
		page.setOrderBy("createDate");
		ShowAdvisor search = new ShowAdvisor();
		page = showAdvisorService.findPage(page, search);
		List<ShowAdvisorPageResponse> resultList = page.getList().stream()
				.map(advisor -> {
					ShowAdvisorPageResponse resp = new ShowAdvisorPageResponse();
					BeanUtil.copyProperties(resp, advisor, "yyyy-MM-dd");
					resp.setPicture(ImgUtil.getImgUrl(httpRequest, advisor.getPicture()));
					return resp;
				})
				.collect(Collectors.toList());
		long totalPage = (page.getCount() + page.getPageSize() - 1) / page.getPageSize();
		return PageResultDto.success(resultList, page.getCount(), totalPage);
	}

	@ApiOperation(value = "详情")
	@GetMapping(value = "/detail")
	@ResponseBody
	public ResultDto<ShowAdvisorDetailResponse> findDetail(@Valid ShowAdvisorDetailRequest request, HttpServletRequest httpRequest) {
		BeanValidators.validateWithException(validator, request);
		ShowAdvisor advisor = showAdvisorService.get(request.getId());
		ShowAdvisorDetailResponse resp = new ShowAdvisorDetailResponse();
		BeanUtil.copyProperties(resp, advisor, "yyyy-MM-dd");
		resp.setPicture(ImgUtil.getImgUrl(httpRequest, advisor.getPicture()));
		if ("en".equals(request.getLanguage())) {
			resp.setInvolvedInto(advisor.getInvolvedIntoEn());
			resp.setElectedInto(advisor.getElectedIntoEn());
			resp.setTitle(advisor.getTitleEn());
			resp.setExperience(advisor.getExperienceEn());
			resp.setKennelName(advisor.getKennelNameEn());
			resp.setBreedType(advisor.getBreedTypeEn());
		}
		return ResultDto.success(resp);
	}

}