package com.cku.restful.v1.earnest.service;

import com.alibaba.fastjson.JSONObject;
import com.cku.oa.earnest.dao.EarnestListDao;
import com.cku.oa.earnest.dao.EarnestListItemDao;
import com.cku.oa.earnest.dao.EarnestMoneyDao;
import com.cku.oa.earnest.vo.entity.EarnestList;
import com.cku.oa.earnest.vo.entity.EarnestListItem;
import com.cku.oa.earnest.vo.entity.EarnestMoney;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
public class RestEarnestMoneyService {


    @Autowired
    private PaymentOrderDao paymentOrderDao;
    @Autowired
    private PaymentOrderDetailDao paymentOrderDetailDao;
    @Autowired
    private PaymentChargingItemService paymentChargingItemService;
    @Autowired
    private EarnestMoneyDao earnestMoneyDao;

    @Autowired
    private EarnestListDao earnestListDao;
    @Autowired
    private EarnestListItemDao earnestListItemDao;
    public static final String EARNESTMONEY = "earnest_money";

    public JSONObject toOrder(List<EarnestMoney> list, Member loginMember){
        //订单号
        String runningNumber = SysCodeUtil.getPayRunningNumberWithMemberCode(loginMember.getMemberCode());
        //获取价格
        PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(EARNESTMONEY);
        //插入业务
        list.forEach(earnestMoney -> {
            earnestMoney.setRunningNumber(runningNumber);
            earnestMoneyDao.insert(earnestMoney);
        });
        //生成订单
        PaymentOrder paymentOrder = new PaymentOrder();
        paymentOrder.setMemberCode(loginMember.getMemberCode());
        paymentOrder.setMemberName(loginMember.getName());
        paymentOrder.setIsBuying("0");
        String loginType = UserUtils.getLoginUser().getLoginType();
        paymentOrder.setOrderCode(runningNumber);
        paymentOrder.setAddTime(new Date());
        paymentOrder.setLocked("0");
        paymentOrder.setTotalPrice(paymentChargingItem.getPrice());
        paymentOrder.setPaymentState("1");
        paymentOrder.setSource(loginType);
        paymentOrder.preInsert();
        paymentOrderDao.insert(paymentOrder);
        //生成订单详情
        PaymentOrderDetail detail = new PaymentOrderDetail();
        detail.setOrderCode(paymentOrder.getOrderCode());
        detail.setAddTime(paymentOrder.getCreateDate());
        detail.setProccessState("0");
        detail.setTotalPrice(paymentOrder.getTotalPrice());
        detail.setNum("1");
        detail.setPrice(paymentChargingItem.getPrice());
//        detail.setBusinessIds(po.getId());
//        detail.setBusinessTable("buying_order");
        detail.preInsert();
        detail.setChargingItemId(paymentChargingItem.getId());
        detail.setMemberCode(loginMember.getMemberCode());
        detail.setMemberName(loginMember.getName());
        detail.setChargingItemName(paymentChargingItem.getName());
        paymentOrderDetailDao.insert(detail);

        JSONObject jo = new JSONObject();
        jo.put("id", paymentOrder.getId());
        jo.put("orderCode", paymentOrder.getOrderCode());
        jo.put("price", paymentChargingItem.getPrice());
        return jo;
    }
    public List<EarnestList> findListByGroup(){
        return earnestListDao.findListByGroup();
    }
    public List<EarnestListItem> findList(String brand){
        return earnestListItemDao.findList(brand);
    }
}
