/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.breeder.web;

import com.cku.restful.v1.breeder.service.BreederDogStickerApplyService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 专业繁殖人等级贴纸申请相关业务
 *
 * @author zhuoHeng
 * @version 2016-08-02
 */
@Controller
@RequestMapping(value = "/api/v1/breeder/dog/dogStickerApply")
public class BreederDogStickerApplyController extends BaseRestController {

    @Autowired
    private BreederDogStickerApplyService service;

    @RequestMapping(value = "", method = RequestMethod.POST)
    public void post(@RequestBody String json, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, service.post(json));
    }

    @RequestMapping(value = "/order/{id}", method = RequestMethod.GET)
    public void order(@PathVariable("id") String id, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, service.order(id));
    }

}