package com.cku.restful.v1.appreciation.model;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

@Data
@Builder
@ApiModel
public class RestAppreciationCertificate implements Serializable {

	private static final long serialVersionUID = -1803768688793495459L;

	@ApiModelProperty(value = "证书编号")
	private String certificateCode;

	@ApiModelProperty(value = "会员号")
	private String memberCode;

	@ApiModelProperty(value = "会员姓名")
	private String memberName;

	@ApiModelProperty(value = "课程名称")
	private String courseName;

	@JsonFormat(pattern = "yyyy-MM-dd")
	@ApiModelProperty(value = "课程开始时间")
	private Date courseStartDate;

	@JsonFormat(pattern = "yyyy-MM-dd")
	@ApiModelProperty(value = "课程结束时间")
	private Date courseEndDate;

	@JsonFormat(pattern = "yyyy-MM-dd")
	@ApiModelProperty(value = "签发日期")
	private Date issueDate;

}
