package com.cku.oa.sys.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.sys.entity.Remind;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.util.ConstantUtils;

/**
 * 业务提醒功能Controller
 * @author fanhuibin
 * @version 2016-08-11
 */
@Controller
@RequestMapping(value = "${adminPath}/sys/remind")
public class RemindController extends BaseController {
	
	@Autowired
	private RemindService remindService;
	
	@ModelAttribute
	public Remind get(@RequestParam(required=false) String id) {
		Remind entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = remindService.get(id);
		}
		if (entity == null){
			entity = new Remind();
		}
		return entity;
	}
	
	@RequiresPermissions("sys:remind:view")
	@RequestMapping(value = {"list", ""})
	public String list(Remind remind, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<Remind> page = remindService.findPage(new Page<Remind>(request, response), remind); 
		model.addAttribute("page", page);
		model.addAttribute("REMIND_LEFT",ConstantUtils.REMIND_LEFT);
		return "oa/sys/remindList";
	}

	@RequiresPermissions("sys:remind:view")
	@RequestMapping(value = "form")
	public String form(Remind remind, Model model) {
		model.addAttribute("remind", remind);
		return "oa/sys/remindForm";
	}

	@RequiresPermissions("sys:remind:edit")
	@RequestMapping(value = "save")
	public String save(Remind remind, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, remind)){
			return form(remind, model);
		}
		remindService.save(remind);
		addMessage(redirectAttributes, "保存业务提醒成功");
		return "redirect:"+Global.getAdminPath()+"/sys/remind/?repage";
	}
	
	@RequiresPermissions("sys:remind:edit")
	@RequestMapping(value = "delete")
	public String delete(Remind remind, RedirectAttributes redirectAttributes) {
		remindService.delete(remind);
		addMessage(redirectAttributes, "删除业务提醒成功");
		return "redirect:"+Global.getAdminPath()+"/sys/remind/?repage";
	}

}