package com.cku.oa.sys.service;

import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.util.PinYinUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Title: com.cku.oa.sys.service
 * Description:
 * Company: cab
 *
 * @author yuanshuai
 * @date 2020/5/19 13:51
 */
@Service
@Transactional(readOnly = true)
public class SysScriptService {

	@Autowired
	MemberDao memberDao;

	/**
	 * @Description： 重新生成会员信息
	 * @author: yuanshuai
	 * @date: 2020/5/19 13:55
	 */
	@Transactional(readOnly = false)
	public void reBuildMemberName() {
		List<Member> memberList = memberDao.findAllList(new Member());
		for (Member member : memberList) {
			if(PinYinUtil.isChinese(member.getName())
					&& !member.getMemberCode().startsWith("HZ")
					&& !member.getMemberCode().startsWith("T")
					&& !member.getMemberCode().startsWith("R")
					&& !member.getMemberCode().startsWith("C")
					&& !member.getMemberCode().startsWith("H")
					&& !member.getMemberCode().startsWith("S")
					&& !member.getMemberCode().startsWith("Q")
					&& !member.getMemberCode().startsWith("MRHZ")
					&& !member.getMemberCode().startsWith("CAB")
					&& !member.getMemberCode().startsWith("DQZ")){
				String fullSpell = PinYinUtil.getFullSpell(member.getName());
				memberDao.updateMemberNameEn(member.getMemberCode(), fullSpell);
			}
		}
	}
}
