/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import com.cku.oa.sys.entity.user.Member;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.modules.sys.entity.User;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 合作机构、合作医院Entity
 *
 * @author fanhuibin
 * @version 2016-08-22
 */
public class Org extends DataEntity<Org> {

	private static final long serialVersionUID = 1L;
	private String state; // 状态,已经废弃。
	private String name; // 组织名称
	private String contact; // 联系人
	private String orgCode; // 组织编码
	private Date endDate; // 结束日期
	private BigDecimal deposit; // 押金
	private Date depositDate; // 缴纳押金的时间
	private String orgType; // 机构类型
	private String orgSite; // 所属协会
	private String printOffsetLeft; // 打印左偏移
	private String printOffsetTop; // 打印上偏移
	private String memberCode; // 合作机构对应的会员号
	private User user; // 登录帐号的id
	private String scanner; // 芯片扫描仪
	private String chip; // 芯片(临时存储芯片,作查询使用)
	private Member member;
	private String address;
	private String tel;
	private String visibleFlag; // 会员中心新生犬登记申请页面是否显示标记位：显示0；不显示1；
	private String displayOnWeb; // 网页是否显示
	private String shopMoney = "0";// 俱乐部商城余额
	private String landlinePhone; // 座机电话
	private String yingyePic; // 营业执照照片
	private String shouYiPic; // 兽医资格照片
	private String mendian1Pic; // 门店照
	private String jianDingshi1; // 鉴定师1
	private String jianDingshi2; // 鉴定师2
	private String tuijiansren; // 推荐人
	private String shenHeState;// 0 未审核 1、通过 2未通过

	private String province;
	private String city;
	private String street;
	// 单犬种俱乐部使用
	private String authorizedProvince; // 授权地区-省
	private String authorizedCity; // 授权地区-市
	private String memberCouponNum; // 会员优惠券数量
	private String memberCouponNumCanUse; // 可以使用数量
	private String memberCouponNumUsed; // 已用数量
	private String orgDogType; // 使用犬种
	private String adminCode; // 机构负责人
	private String noseLine; // 是否开通鼻纹采集
	private String dogNoseRepeatedDetection;
	private String dogNoseLivenessDetection;

	private String userId;

	private String loginName;
	private String orgSiteArr[];

	private BigDecimal accountBalance;
	
	private String oaOrder;

	public String getOaOrder() {
		return oaOrder;
	}

	public void setOaOrder(String oaOrder) {
		this.oaOrder = oaOrder;
	}

	public String getDogNoseRepeatedDetection() {
		return dogNoseRepeatedDetection;
	}

	public void setDogNoseRepeatedDetection(String dogNoseRepeatedDetection) {
		this.dogNoseRepeatedDetection = dogNoseRepeatedDetection;
	}

	public String getDogNoseLivenessDetection() {
		return dogNoseLivenessDetection;
	}

	public void setDogNoseLivenessDetection(String dogNoseLivenessDetection) {
		this.dogNoseLivenessDetection = dogNoseLivenessDetection;
	}

	public String[] getOrgSiteArr() {
		return orgSiteArr;
	}

	public void setOrgSiteArr(String[] orgSiteArr) {
		this.orgSiteArr = orgSiteArr;
	}

	public String getOrgSite() {
		return orgSite;
	}

	public void setOrgSite(String orgSite) {
		this.orgSite = orgSite;
	}

	public String getMemberCouponNumUsed() {
		return memberCouponNumUsed;
	}

	public void setMemberCouponNumUsed(String memberCouponNumUsed) {
		this.memberCouponNumUsed = memberCouponNumUsed;
	}

	public Org() {
		super();
	}

	public Org(String id) {
		super(id);
	}

	@Length(min = 0, max = 1, message = "状态长度必须介于 0 和 1 之间")
	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	@Length(min = 1, max = 50, message = "组织名称长度必须介于 1 和 50 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Length(min = 1, max = 50, message = "联系人长度必须介于 1 和 50 之间")
	public String getContact() {
		return contact;
	}

	public void setContact(String contact) {
		this.contact = contact;
	}

	@Length(min = 0, max = 50, message = "组织编码长度必须介于 0 和 50 之间")
	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public BigDecimal getDeposit() {
		return deposit;
	}

	public void setDeposit(BigDecimal deposit) {
		this.deposit = deposit;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getDepositDate() {
		return depositDate;
	}

	public void setDepositDate(Date depositDate) {
		this.depositDate = depositDate;
	}

	@Length(min = 0, max = 1000, message = "机构类型长度必须介于 0 和 1000 之间")
	public String getOrgType() {
		return orgType;
	}

	public void setOrgType(String orgType) {
		this.orgType = orgType;
	}

	@Length(min = 0, max = 11, message = "打印左偏移长度必须介于 0 和 11 之间")
	public String getPrintOffsetLeft() {
		return printOffsetLeft;
	}

	public void setPrintOffsetLeft(String printOffsetLeft) {
		this.printOffsetLeft = printOffsetLeft;
	}

	@Length(min = 0, max = 11, message = "打印上偏移长度必须介于 0 和 11 之间")
	public String getPrintOffsetTop() {
		return printOffsetTop;
	}

	public void setPrintOffsetTop(String printOffsetTop) {
		this.printOffsetTop = printOffsetTop;
	}

	@Length(min = 0, max = 64, message = "合作机构对应的会员号长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@NotNull(message = "登录帐号的id不能为空")
	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	@Length(min = 0, max = 10, message = "芯片扫描仪长度必须介于 0 和 10 之间")
	public String getScanner() {
		return scanner;
	}

	public void setScanner(String scanner) {
		this.scanner = scanner;
	}

	public Member getMember() {
		return member;
	}

	public void setMember(Member member) {
		this.member = member;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getTel() {
		return tel;
	}

	public void setTel(String tel) {
		this.tel = tel;
	}

	public String getShopMoney() {
		return shopMoney;
	}

	public void setShopMoney(String shopMoney) {
		this.shopMoney = shopMoney;
	}

	public String getChip() {
		return chip;
	}

	public void setChip(String chip) {
		this.chip = chip;
	}

	public String getVisibleFlag() {
		return visibleFlag;
	}

	public void setVisibleFlag(String visibleFlag) {
		this.visibleFlag = visibleFlag;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getStreet() {
		return street;
	}

	public void setStreet(String street) {
		this.street = street;
	}

	public String getDisplayOnWeb() {
		return displayOnWeb;
	}

	public void setDisplayOnWeb(String displayOnWeb) {
		this.displayOnWeb = displayOnWeb;
	}

	public String getLandlinePhone() {
		return landlinePhone;
	}

	public void setLandlinePhone(String landlinePhone) {
		this.landlinePhone = landlinePhone;
	}

	public String getYingyePic() {
		return yingyePic;
	}

	public void setYingyePic(String yingyePic) {
		this.yingyePic = yingyePic;
	}

	public String getShouYiPic() {
		return shouYiPic;
	}

	public void setShouYiPic(String shouYiPic) {
		this.shouYiPic = shouYiPic;
	}

	public String getMendian1Pic() {
		return mendian1Pic;
	}

	public void setMendian1Pic(String mendian1Pic) {
		this.mendian1Pic = mendian1Pic;
	}

	public String getJianDingshi1() {
		return jianDingshi1;
	}

	public void setJianDingshi1(String jianDingshi1) {
		this.jianDingshi1 = jianDingshi1;
	}

	public String getJianDingshi2() {
		return jianDingshi2;
	}

	public void setJianDingshi2(String jianDingshi2) {
		this.jianDingshi2 = jianDingshi2;
	}

	public String getTuijiansren() {
		return tuijiansren;
	}

	public void setTuijiansren(String tuijiansren) {
		this.tuijiansren = tuijiansren;
	}

	public String getShenHeState() {
		return shenHeState;
	}

	public void setShenHeState(String shenHeState) {
		this.shenHeState = shenHeState;
	}

	public String getAuthorizedProvince() {
		return authorizedProvince;
	}

	public void setAuthorizedProvince(String authorizedProvince) {
		this.authorizedProvince = authorizedProvince;
	}

	public String getAuthorizedCity() {
		return authorizedCity;
	}

	public String getAdminCode() {
		return adminCode;
	}

	public void setAdminCode(String adminCode) {
		this.adminCode = adminCode;
	}

	public void setAuthorizedCity(String authorizedCity) {
		this.authorizedCity = authorizedCity;
	}

	public String getMemberCouponNum() {
		return memberCouponNum;
	}

	public void setMemberCouponNum(String memberCouponNum) {
		this.memberCouponNum = memberCouponNum;
	}

	public String getMemberCouponNumCanUse() {
		return memberCouponNumCanUse;
	}

	public void setMemberCouponNumCanUse(String memberCouponNumCanUse) {
		this.memberCouponNumCanUse = memberCouponNumCanUse;
	}

	public String getOrgDogType() {
		return orgDogType;
	}

	public void setOrgDogType(String orgDogType) {
		this.orgDogType = orgDogType;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getLoginName() {
		return loginName;
	}

	public void setLoginName(String loginName) {
		this.loginName = loginName;
	}

	public BigDecimal getAccountBalance() {
		return accountBalance;
	}

	public void setAccountBalance(BigDecimal accountBalance) {
		this.accountBalance = accountBalance;
	}

	public String getNoseLine() {
		return noseLine;
	}

	public void setNoseLine(String noseLine) {
		this.noseLine = noseLine;
	}




}