/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.coupon.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 优惠券配置信息Entity
 * 
 * @author zjw
 * @version 2020-06-04
 */
public class SysCouponDef extends DataEntity<SysCouponDef> {

	private static final long serialVersionUID = 1L;
	private String couponName; // 优惠劵名称
	private String couponType; // 1代金券 2抵扣券 3参赛券 4满减券
	private String facePrice; // 面值
	private int effectivePeriod; // 时效:单位月
	private String explains; // 说明
	private String target; // 用于对象
	private Date effectiveDate; // 生效日期
	private Integer num; // 限制数量（不填为不限）
	private Date validDate; // 生效日期

	public Date getValidDate() {
		return validDate;
	}

	public void setValidDate(Date validDate) {
		this.validDate = validDate;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public Integer getNum() {
		return num;
	}

	public void setNum(Integer num) {
		this.num = num;
	}

	public SysCouponDef() {
		super();
	}

	public SysCouponDef(String id) {
		super(id);
	}

	@Length(min = 0, max = 100, message = "优惠劵名称长度必须介于 0 和 100 之间")
	public String getCouponName() {
		return couponName;
	}

	public void setCouponName(String couponName) {
		this.couponName = couponName;
	}

	@Length(min = 0, max = 11, message = "1代金券 2抵扣券 3参赛券长度必须介于 0 和 11 之间")
	public String getCouponType() {
		return couponType;
	}

	public void setCouponType(String couponType) {
		this.couponType = couponType;
	}

	@Length(min = 0, max = 11, message = "面值长度必须介于 0 和 11 之间")
	public String getFacePrice() {
		return facePrice;
	}

	public void setFacePrice(String facePrice) {
		this.facePrice = facePrice;
	}

	@Length(min = 0, max = 11, message = "时效:单位月长度必须介于 0 和 11 之间")
	public int getEffectivePeriod() {
		return effectivePeriod;
	}

	public void setEffectivePeriod(int effectivePeriod) {
		this.effectivePeriod = effectivePeriod;
	}

	@Length(min = 0, max = 150, message = "说明长度必须介于 0 和 150 之间")
	public String getExplains() {
		return explains;
	}

	public void setExplains(String explains) {
		this.explains = explains;
	}

	@Length(min = 0, max = 150, message = "用于对象长度必须介于 0 和 150 之间")
	public String getTarget() {
		return target;
	}

	public void setTarget(String target) {
		this.target = target;
	}

}