package com.cku.oa.show.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.show.entity.ShowJudge;
import com.cku.oa.show.service.ShowJudgeService;

/**
 * 犬展裁判Controller
 * @author lgl
 * @version 2016-08-20
 */
@Controller
@RequestMapping(value = "${adminPath}/judge/showJudge")
public class ShowJudgeController extends BaseController {

	@Autowired
	private ShowJudgeService showJudgeService;
	
	@ModelAttribute
	public ShowJudge get(@RequestParam(required=false) String id) {
		ShowJudge entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = showJudgeService.get(id);
		}
		if (entity == null){
			entity = new ShowJudge();
		}
		return entity;
	}
	
	@RequiresPermissions("judge:showJudge:view")
	@RequestMapping(value = {"list", ""})
	public String list(ShowJudge showJudge, HttpServletRequest request, HttpServletResponse response, Model model) {
		if(StringUtils.isNotBlank(showJudge.getJudgeName())){
			showJudge.setJudgeName(StringEscapeUtils.unescapeHtml4(showJudge.getJudgeName()));
		}
		Page<ShowJudge> page = showJudgeService.findPage(new Page<ShowJudge>(request, response), showJudge); 
		model.addAttribute("page", page);
		return "oa/show/judge/showJudgeList";
	}

	@RequiresPermissions("judge:showJudge:view")
	@RequestMapping(value = "form")
	public String form(ShowJudge showJudge, Model model) {
		model.addAttribute("showJudge", showJudge);
		return "oa/show/judge/showJudgeForm";
	}
	
	@RequiresPermissions("judge:showJudge:view")
	@RequestMapping(value = "view")
	public String view(ShowJudge showJudge, Model model) {
		model.addAttribute("showJudge", showJudge);
		return "oa/show/judge/showJudgeView";
	}

	@RequestMapping(value = "save")
	public String save(ShowJudge showJudge, Model model, RedirectAttributes redirectAttributes) {
		boolean hasPermission = false;
		if(StringUtils.isEmpty(showJudge.getId())){
			hasPermission = SecurityUtils.getSubject().isPermitted("judge:showJudge:add");
		}else{
			hasPermission = SecurityUtils.getSubject().isPermitted("judge:showJudge:edit");
		}
		if(!hasPermission){
			throw new AuthorizationException("用户权限不足");
		}
		if (!beanValidator(model, showJudge)){
			return form(showJudge, model);
		}
		showJudgeService.save(showJudge);
		addMessage(redirectAttributes, "保存犬展裁判成功");
		return "redirect:"+Global.getAdminPath()+"/judge/showJudge/?repage";
	}
	
	@RequiresPermissions("judge:showJudge:delete")
	@RequestMapping(value = "delete")
	public String delete(ShowJudge showJudge, RedirectAttributes redirectAttributes) {
		showJudgeService.delete(showJudge);
		addMessage(redirectAttributes, "删除犬展裁判成功");
		return "redirect:"+Global.getAdminPath()+"/judge/showJudge/?repage";
	}

}