/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import java.util.Date;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

/**
 * 香港赛事成绩表Entity
 * @author xx
 * @version 2024-11-14
 */
public class ShowResultsHk extends DataEntity<ShowResultsHk> {
	
	private static final long serialVersionUID = 1L;
	@NotBlank
	@ExcelField(title = "赛事名称", align = 2, sort = 1)
	private String showName;		// 赛事名称
	@NotBlank
	@ExcelField(title = "赛事编号", align = 2, sort = 2)
	private String showCode;		// 赛事编号
	@ExcelField(title = "BOB项成绩", align = 2, sort = 3)
	private String resultBob;		// bob项成绩
	@ExcelField(title = "BIS项成绩", align = 2, sort = 4)
	private String resultBis;		// BIS项成绩
	@ExcelField(title = "BIG项成绩", align = 2, sort = 5)
	private String resultBig;		// BIG项成绩
	@NotBlank
	@ExcelField(title = "血统证书号", align = 2, sort = 6)
	private String pedigreeCertified;		// 血统证书号
	@NotBlank
	@ExcelField(title = "犬名", align = 2, sort = 14)
	private String dogName;		// 犬名
	@NotBlank
	@ExcelField(title = "犬主名", align = 2, sort = 7)
	private String dogOwnerName;		// 犬主名
	@NotBlank
	@ExcelField(title = "犬性别", align = 2, sort = 8)
	private String dogGender;		// 犬性别
	@NotNull
	@ExcelField(title = "出生日期", align = 2, sort = 9)
	private Date birthdate;		// 出生日期
	@NotNull
	@ExcelField(title = "比赛日期", align = 2, sort = 10)
	private Date startTime;		// 比赛日期
	@ExcelField(title = "繁殖人", align = 2, sort = 11)
	private String breeder;		// 繁殖人
	private String dogBreedCn;		// 种类
	private String dogBreedEn;		// 种类英文
	@NotBlank
	@ExcelField(title = "FCI代码", align = 2, sort = 12)
	private String fciCode;		// FCI码
	private String year;		// 官网成绩排名所属年份
	@ExcelField(title = "年龄组别", align = 2, sort = 13)
	private String ageGroup;		// 年龄组别
	private String showResult;		// 本场积分
	
	
	public ShowResultsHk() {
		super();
	}

	public ShowResultsHk(String id){
		super(id);
	}
	
	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public String getShowResult() {
		return showResult;
	}

	public void setShowResult(String showResult) {
		this.showResult = showResult;
	}

	@Length(min=0, max=100, message="赛事名称长度必须介于 0 和 100 之间")
	public String getShowName() {
		return showName;
	}

	public void setShowName(String showName) {
		this.showName = showName;
	}
	
	@Length(min=0, max=100, message="赛事编号长度必须介于 0 和 100 之间")
	public String getShowCode() {
		return showCode;
	}

	public void setShowCode(String showCode) {
		this.showCode = showCode;
	}
	
	public String getResultBob() {
		return resultBob;
	}

	public void setResultBob(String resultBob) {
		this.resultBob = resultBob;
	}
	
	public String getResultBis() {
		return resultBis;
	}

	public void setResultBis(String resultBis) {
		this.resultBis = resultBis;
	}
	
	public String getResultBig() {
		return resultBig;
	}

	public void setResultBig(String resultBig) {
		this.resultBig = resultBig;
	}
	
	@Length(min=0, max=64, message="血统证书号长度必须介于 0 和 64 之间")
	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}
	
	@Length(min=0, max=100, message="犬主中文名长度必须介于 0 和 100 之间")
	public String getDogOwnerName() {
		return dogOwnerName;
	}

	public void setDogOwnerName(String dogOwnerName) {
		this.dogOwnerName = dogOwnerName;
	}
	
	
	@Length(min=0, max=1, message="犬性别长度必须介于 0 和 1 之间")
	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getBirthdate() {
		return birthdate;
	}

	public void setBirthdate(Date birthdate) {
		this.birthdate = birthdate;
	}
	
	public String getBreeder() {
		return breeder;
	}

	public void setBreeder(String breeder) {
		this.breeder = breeder;
	}
	
	public String getDogBreedCn() {
		return dogBreedCn;
	}

	public void setDogBreedCn(String dogBreedCn) {
		this.dogBreedCn = dogBreedCn;
	}
	
	public String getDogBreedEn() {
		return dogBreedEn;
	}

	public void setDogBreedEn(String dogBreedEn) {
		this.dogBreedEn = dogBreedEn;
	}
	
	@Length(min=0, max=6, message="FCI码长度必须介于 0 和 6 之间")
	public String getFciCode() {
		return fciCode;
	}

	public void setFciCode(String fciCode) {
		this.fciCode = fciCode;
	}
	
	public String getYear() {
		return year;
	}

	public void setYear(String year) {
		this.year = year;
	}
	
	public String getAgeGroup() {
		return ageGroup;
	}

	public void setAgeGroup(String ageGroup) {
		this.ageGroup = ageGroup;
	}

	public String getDogName() {
		return dogName;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}
	
	
	
}