/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import java.util.Date;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

/**
 * 单独展赛事成绩Entity
 * 
 * @author lgl
 * @version 2016-07-21
 */
public class ShowResultsDdz extends DataEntity<ShowResultsDdz> {

	private static final long serialVersionUID = 1L;
	private String dogId; // 犬只信息表主键
	@ExcelField(title = "犬展编号", align = 2, sort = 6)
	private String showCode; // 赛事编号
	private String year; // 官网成绩排名所属年份（默认去赛事编号年份，当赛事跨年，可以手动修改年份为下一年）
	@ExcelField(title = "裁判", align = 2, sort = 43)
	private String referee; // 裁判
	@ExcelField(title = "血统证书号", align = 2, sort = 33)
	private String pedigreeCertified; // 血统证书号
	@ExcelField(title = "外国血统证书号", align = 2, sort = 34)
	private String otherCertified; // 其他证书号
	@ExcelField(title = "赛圈", align = 2, sort = 44)
	private String raceLap; // 赛圈
	@ExcelField(title = "犬种组", align = 2, sort = 27)
	private String dogBreedGroup; // 犬种组
	@ExcelField(title = "年龄组别", align = 2, sort = 32)
	private String ageGroup; // 年龄组别
	@ExcelField(title = "犬性别", align = 2, sort = 29)
	private String dogGender; // 犬性别
	@ExcelField(title = "FCI代码", align = 2, sort = 26)
	private String fciCode; // FCI码
	@ExcelField(title = "犬主中文名", align = 2, sort = 20)
	private String dogOwnerNameCn; // 犬主中文名
	@ExcelField(title = "犬主英文名", align = 2, sort = 22)
	private String dogOwnerNameEn; // 犬主英文名
	@ExcelField(title = "犬主会员号", align = 2, sort = 23)
	private String dogOwnerMemberCode; // 犬主会员号
	@ExcelField(title = "本场积分", align = 2, sort = 19)
	private String showResult; // 本场积分
	@ExcelField(title = "秩序号", align = 2, sort = 7)
	private String orderCode; // 秩序号
	@ExcelField(title = "评价", align = 2, sort = 9)
	private String appraisal; // 评价
	@ExcelField(title = "CC", align = 2, sort = 10)
	private String resultCc; // cc项成绩
	@ExcelField(title = "CC备注", align = 2, sort = 8)
	private String remarksCc; // CC备注
	@ExcelField(title = "BOB", align = 2, sort = 16)
	private String resultBob; // bob项成绩
	@ExcelField(title = "BOW", align = 2, sort = 14)
	private String resultBow; // BOW项成绩
	@ExcelField(title = "WB", align = 2, sort = 17)
	private String resultWb; // WB项成绩
	@ExcelField(title = "BISS", align = 2, sort = 18)
	private String resultBiss; // BISS项成绩
	@ExcelField(title = "小组排名", align = 2, sort = 11)
	private String rankings; // 小组排名
	private String formatcode; // formatCode
	@ExcelField(title = "c37", align = 2, sort = 37)
	private String remarks;	// 备注
	private String[] resultCcs;
	@ExcelField(title = "本场单犬种积分", align = 2, sort = 46)
	private String showBreedResult; // 本场积分
	
	public String getShowBreedResult() {
		return showBreedResult;
	}

	public void setShowBreedResult(String showBreedResult) {
		this.showBreedResult = showBreedResult;
	}
	public ShowResultsDdz() {
		super();
	}

	public ShowResultsDdz(String id) {
		super(id);
	}

	// @Length(min=0, max=64, message="犬只信息表主键长度必须介于 0 和 64 之间")
	public String getDogId() {
		return dogId;
	}

	public void setDogId(String dogId) {
		this.dogId = dogId;
	}

	// @Length(min=0, max=64, message="赛事编号长度必须介于 0 和 64 之间")
	public String getShowCode() {
		return showCode;
	}

	public void setShowCode(String showCode) {
		this.showCode = showCode;
	}

	public String getYear() {
		return year;
	}

	public void setYear(String year) {
		this.year = year;
	}

	// @Length(min=0, max=50, message="裁判长度必须介于 0 和 50 之间")
	public String getReferee() {
		return referee;
	}

	public void setReferee(String referee) {
		this.referee = referee;
	}

	// @Length(min=0, max=64, message="血统证书号长度必须介于 0 和 64 之间")
	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}

	// @Length(min=0, max=64, message="其他证书号长度必须介于 0 和 64 之间")
	public String getOtherCertified() {
		return otherCertified;
	}

	public void setOtherCertified(String otherCertified) {
		this.otherCertified = otherCertified;
	}

	// @Length(min=1, max=10, message="赛圈长度必须介于 1 和 10 之间")
	public String getRaceLap() {
		return raceLap;
	}

	public void setRaceLap(String raceLap) {
		this.raceLap = raceLap;
	}

	// @Length(min=0, max=10, message="犬种组长度必须介于 0 和 10 之间")
	public String getDogBreedGroup() {
		return dogBreedGroup;
	}

	public void setDogBreedGroup(String dogBreedGroup) {
		this.dogBreedGroup = dogBreedGroup;
	}

	// @Length(min=0, max=2, message="年龄组别长度必须介于 0 和 2 之间")
	public String getAgeGroup() {
		return ageGroup;
	}

	public void setAgeGroup(String ageGroup) {
		this.ageGroup = ageGroup;
	}

	// @Length(min=0, max=1, message="犬性别长度必须介于 0 和 1 之间")
	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}

	// @Length(min=0, max=6, message="FCI码长度必须介于 0 和 6 之间")
	public String getFciCode() {
		return fciCode;
	}

	public void setFciCode(String fciCode) {
		this.fciCode = fciCode;
	}

	// @Length(min=0, max=50, message="犬主中文名长度必须介于 0 和 50 之间")
	public String getDogOwnerNameCn() {
		return dogOwnerNameCn;
	}

	public void setDogOwnerNameCn(String dogOwnerNameCn) {
		this.dogOwnerNameCn = dogOwnerNameCn;
	}

	// @Length(min=0, max=50, message="犬主英文名长度必须介于 0 和 50 之间")
	public String getDogOwnerNameEn() {
		return dogOwnerNameEn;
	}

	public void setDogOwnerNameEn(String dogOwnerNameEn) {
		this.dogOwnerNameEn = dogOwnerNameEn;
	}

	// @Length(min=0, max=64, message="犬主会员号长度必须介于 0 和 64 之间")
	public String getDogOwnerMemberCode() {
		return dogOwnerMemberCode;
	}

	public void setDogOwnerMemberCode(String dogOwnerMemberCode) {
		this.dogOwnerMemberCode = dogOwnerMemberCode;
	}

	// @Length(min=0, max=11, message="本场积分长度必须介于 0 和 11 之间")
	public String getShowResult() {
		return showResult;
	}

	public void setShowResult(String showResult) {
		this.showResult = showResult;
	}

	// @Length(min=0, max=5, message="秩序号长度必须介于 0 和 5 之间")
	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public String getAppraisal() {
		return appraisal;
	}

	public void setAppraisal(String appraisal) {
		this.appraisal = appraisal;
	}

	// @Length(min=0, max=1, message="cc项成绩长度必须介于 0 和 1 之间")
	public String getResultCc() {
		return resultCc;
	}

	public void setResultCc(String resultCc) {
		this.resultCc = resultCc;
	}

	// @Length(min=0, max=100, message="CC备注长度必须介于 0 和 100 之间")
	public String getRemarksCc() {
		return remarksCc;
	}

	public void setRemarksCc(String remarksCc) {
		this.remarksCc = remarksCc;
	}

	// @Length(min=0, max=2, message="bob项成绩长度必须介于 0 和 2 之间")
	public String getResultBob() {
		return resultBob;
	}

	public void setResultBob(String resultBob) {
		this.resultBob = resultBob;
	}

	// @Length(min=0, max=20, message="BOW项成绩长度必须介于 0 和 20 之间")
	public String getResultBow() {
		return resultBow;
	}

	public void setResultBow(String resultBow) {
		this.resultBow = resultBow;
	}

	// @Length(min=0, max=20, message="WB项成绩长度必须介于 0 和 20 之间")
	public String getResultWb() {
		return resultWb;
	}

	public void setResultWb(String resultWb) {
		this.resultWb = resultWb;
	}

	// @Length(min=0, max=1, message="BISS项成绩长度必须介于 0 和 1 之间")
	public String getResultBiss() {
		return resultBiss;
	}

	public void setResultBiss(String resultBiss) {
		this.resultBiss = resultBiss;
	}

	// @Length(min=0, max=20, message="小组排名长度必须介于 0 和 20 之间")
	public String getRankings() {
		return rankings;
	}

	public void setRankings(String rankings) {
		this.rankings = rankings;
	}

	// @Length(min=0, max=10, message="formatCode长度必须介于 0 和 10 之间")
	public String getFormatcode() {
		return formatcode;
	}

	public void setFormatcode(String formatcode) {
		this.formatcode = formatcode;
	}

	@ExcelField(title = "c1", align = 2, sort = 1)
	private String c1;
	@ExcelField(title = "c2", align = 2, sort = 2)
	private String c2;
	@ExcelField(title = "c3", align = 2, sort = 3)
	private String c3;
	@ExcelField(title = "c4", align = 2, sort = 4)
	private String c4;
	@ExcelField(title = "赛制", align = 2, sort = 5)
	private String showRules; // 赛制
//	@ExcelField(title = "c8", align = 2, sort = 8)
//	private String c8;
	@ExcelField(title = "c9", align = 2, sort = 9)
	private String c9;
	@ExcelField(title = "c12", align = 2, sort = 12)
	private String c12;
	@ExcelField(title = "c13", align = 2, sort = 13)
	private String c13;
	@ExcelField(title = "c15", align = 2, sort = 15)
	private String c15;
	@ExcelField(title = "c21", align = 2, sort = 21)
	private String c21;
	@ExcelField(title = "c24", align = 2, sort = 24)
	private String c24;
	@ExcelField(title = "c25", align = 2, sort = 25)
	private String c25;
	@ExcelField(title = "c28", align = 2, sort = 28)
	private String c28;
	@ExcelField(title = "c30", align = 2, sort = 30)
	private String c30;
	@ExcelField(title = "c31", align = 2, sort = 31)
	private String c31;
	@ExcelField(title = "c35", align = 2, sort = 35)
	private String c35;
	@ExcelField(title = "c36", align = 2, sort = 36)
	private String c36;
	@ExcelField(title = "c38", align = 2, sort = 38)
	private String c38;
	@ExcelField(title = "c39", align = 2, sort = 39)
	private String c39;
	@ExcelField(title = "c40", align = 2, sort = 40)
	private String c40;
	@ExcelField(title = "c41", align = 2, sort = 41)
	private String c41;
	@ExcelField(title = "c42", align = 2, sort = 42)
	private String c42;
	@ExcelField(title = "c45", align = 2, sort = 45)
	private String c45;

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public String getC1() {
		return c1;
	}

	public void setC1(String c1) {
		this.c1 = c1;
	}

	public String getC2() {
		return c2;
	}

	public void setC2(String c2) {
		this.c2 = c2;
	}

	public String getC3() {
		return c3;
	}

	public void setC3(String c3) {
		this.c3 = c3;
	}

	public String getC4() {
		return c4;
	}

	public void setC4(String c4) {
		this.c4 = c4;
	}

	public String getShowRules() {
		return showRules;
	}

	public void setShowRules(String showRules) {
		this.showRules = showRules;
	}

//	public String getC8() {
//		return c8;
//	}
//
//	public void setC8(String c8) {
//		this.c8 = c8;
//	}

	public String getC9() {
		return c9;
	}

	public void setC9(String c9) {
		this.c9 = c9;
	}

	public String getC12() {
		return c12;
	}

	public void setC12(String c12) {
		this.c12 = c12;
	}

	public String getC13() {
		return c13;
	}

	public void setC13(String c13) {
		this.c13 = c13;
	}

	public String getC15() {
		return c15;
	}

	public void setC15(String c15) {
		this.c15 = c15;
	}

	public String getC21() {
		return c21;
	}

	public void setC21(String c21) {
		this.c21 = c21;
	}

	public String getC24() {
		return c24;
	}

	public void setC24(String c24) {
		this.c24 = c24;
	}

	public String getC25() {
		return c25;
	}

	public void setC25(String c25) {
		this.c25 = c25;
	}

	public String getC28() {
		return c28;
	}

	public void setC28(String c28) {
		this.c28 = c28;
	}

	public String getC30() {
		return c30;
	}

	public void setC30(String c30) {
		this.c30 = c30;
	}

	public String getC31() {
		return c31;
	}

	public void setC31(String c31) {
		this.c31 = c31;
	}

	public String getC38() {
		return c38;
	}

	public void setC38(String c38) {
		this.c38 = c38;
	}

	public String getC39() {
		return c39;
	}

	public void setC39(String c39) {
		this.c39 = c39;
	}

	public String getC40() {
		return c40;
	}

	public void setC40(String c40) {
		this.c40 = c40;
	}


	public String getC35() {
		return c35;
	}

	public void setC35(String c35) {
		this.c35 = c35;
	}

	public String getC36() {
		return c36;
	}

	public void setC36(String c36) {
		this.c36 = c36;
	}

	public String getC41() {
		return c41;
	}

	public void setC41(String c41) {
		this.c41 = c41;
	}

	public String getC42() {
		return c42;
	}

	public void setC42(String c42) {
		this.c42 = c42;
	}

	public String getC45() {
		return c45;
	}

	public void setC45(String c45) {
		this.c45 = c45;
	}

	// CKU官网查询所需
	private Date startTime; // 开始时间
	private Date endTime; // 结束时间
	private String showName; // 赛事名称

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public String getShowName() {
		return showName;
	}

	public void setShowName(String showName) {
		this.showName = showName;
	}

	public String[] getResultCcs() {
		return resultCcs;
	}

	public void setResultCcs(String[] resultCcs) {
		this.resultCcs = resultCcs;
	}
	
}