/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.show.entity.ShowResultsDdz;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 单独展赛事成绩DAO接口
 * 
 * @author lgl
 * @version 2016-07-21
 */
@MyBatisDao
public interface ShowResultsDdzDao extends CrudDao<ShowResultsDdz> {
	// <!-- CKU官网根据血统证书号或芯片号进行查询 -->
	public List<ShowResultsDdz> getByKey(@Param("key") String key);

	/**
	 * 
	 * @description: 根据赛事编号和血统证书号查询条数
	 * @author: laiguanglong
	 * @date: 2016年10月19日 下午2:41:56
	 */
	int countByShowCodeAndPedigreeCertified(@Param("showCode") String showCode,
			@Param("pedigreeCertified") String pedigreeCertified);

	/**
	 * @description: 根据血统证书号查询获得的BISS成绩数量
	 * @author: laiguanglong
	 * @date: 2017/10/11 17:23
	 */
	int getBissCountByPedigreeCertified(@Param("pedigreeCertified") String pedigreeCertified);

	List<ShowResultsDdz> getDogGradeDdzList(@Param("pedigreeNum") String pedigreeNum,
			@Param("charTime") String charTime);
	
	void initShowBreedResult(String showCode);
	 
	void updateBreedResutlBISSWithBOV(String showCode);
	
	void updateBreedResutlBISSWithoutBOV(String showCode);
	
	void updateBreedResutlDdzBOB(String showCode);
	
	void updateBreedResutlDdzBOV(String showCode);
	
	void updateBreedResutlDdzBIG(String showCode);
	
	void updateBreedResutlDdzBPPBOB(@Param("showCode") String showCode,@Param("resultBob") String resultBob);
	

}