/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.kennel.entity;

import org.hibernate.validator.constraints.Length;

import java.util.Date;

import com.cku.oa.sys.entity.user.Member;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 犬舍所有人变更Entity
 * @author zhuguanjin
 * @version 2016-08-23
 */
public class KennelOwnerChange extends DataEntity<KennelOwnerChange> {
	
	private static final long serialVersionUID = 1L;
	private String originOwnerMemberCode;		// 原犬舍所有人会员号
	private String kennelCode;		// 犬舍编号
	private String newOwnerMemberCode;		// 新犬舍所有人会员号
	private String paymentMoney;		// 付款的金额
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String paymentState;		// 付款的状态
	private Date paymentTime;		// payment_time
	private String processState;		// process_state
	private Date processTime;		// 流程变更的时间
	private String runningNumber;		// 流水号
	private String reviewRemarks;		// 审核的意见
	private String operator;		// 操作人
	private Member member1;		//会员
	private Member member2;		//会员
	private Kennel kennel;		//犬舍
	private Date beginDate;			//筛选条件中的起始日期
	private Date endDate;			//筛选条件中的终止日期
	private String chargingItemId;
	private String kennelCodeStr;
	
	public KennelOwnerChange() {
		super();
	}

	public KennelOwnerChange(String id){
		super(id);
	}


	@Length(min=0, max=64, message="原犬舍所有人会员号长度必须介于 0 和 64 之间")
	public String getOriginOwnerMemberCode() {
		return originOwnerMemberCode;
	}

	public void setOriginOwnerMemberCode(String originOwnerMemberCode) {
		this.originOwnerMemberCode = originOwnerMemberCode;
	}
	
	@Length(min=0, max=50, message="犬舍编号长度必须介于 0 和 50 之间")
	public String getKennelCode() {
		return kennelCode;
	}

	public void setKennelCode(String kennelCode) {
		this.kennelCode = kennelCode;
	}
	
	@Length(min=0, max=64, message="新犬舍所有人会员号长度必须介于 0 和 64 之间")
	public String getNewOwnerMemberCode() {
		return newOwnerMemberCode;
	}

	public void setNewOwnerMemberCode(String newOwnerMemberCode) {
		this.newOwnerMemberCode = newOwnerMemberCode;
	}
	
	public String getPaymentMoney() {
		return paymentMoney;
	}

	public void setPaymentMoney(String paymentMoney) {
		this.paymentMoney = paymentMoney;
	}
	
	@Length(min=0, max=20, message="审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}
	
	@Length(min=0, max=20, message="付款的状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}
	
	@Length(min=0, max=20, message="process_state长度必须介于 0 和 20 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProcessTime() {
		return processTime;
	}

	public void setProcessTime(Date processTime) {
		this.processTime = processTime;
	}
	
	@Length(min=0, max=100, message="流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}
	
	@Length(min=0, max=255, message="审核的意见长度必须介于 0 和 255 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}
	
	@Length(min=1, max=500, message="创建人长度必须介于 1 和 500 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public Member getMember1() {
		return member1;
	}

	public void setMember1(Member member1) {
		this.member1 = member1;
	}

	public Member getMember2() {
		return member2;
	}

	public void setMember2(Member member2) {
		this.member2 = member2;
	}

	public Kennel getKennel() {
		return kennel;
	}

	public void setKennel(Kennel kennel) {
		this.kennel = kennel;
	}

	public Date getBeginDate() {
		return beginDate;
	}

	public void setBeginDate(Date beginDate) {
		this.beginDate = beginDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getChargingItemId() {
		return chargingItemId;
	}

	public void setChargingItemId(String chargingItemId) {
		this.chargingItemId = chargingItemId;
	}

	public String getKennelCodeStr() {
		return kennelCodeStr;
	}

	public void setKennelCodeStr(String kennelCodeStr) {
		this.kennelCodeStr = kennelCodeStr;
	}
	
}