/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.entity;

import com.cku.cab.editor.ckuhotel.entity.AppCkuHotel;
import com.cku.cab.editor.handlervenue.entity.AppHandlerVenue;
import com.cku.oa.show.entity.AppShowJudge;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 活动详情Entity
 * 
 * @author 张向
 * @version 2020-10-16
 */
@ApiModel
@Data
public class AppHandlerShowDetail {
	@ApiModelProperty("活动id")
	private String id;
	//活动介绍
	@ApiModelProperty("活动名称")
	private String showName; //
	@ApiModelProperty("活动地点")
	private String showAddress; //
	@ApiModelProperty("活动介绍")
	private String showIntroduce;
	@ApiModelProperty("开始日期")
	private String startTime;
	@ApiModelProperty("结束日期")
	private String endTime;
	@ApiModelProperty("截止时间")
	private String registerEndTime;
	//费用明细
	@ApiModelProperty("考试级别")
	private String testLevel; //
	@ApiModelProperty("报名费")
	private String fee; //
	@ApiModelProperty("报名优惠")
	private String discount; //
	//审查员
	@ApiModelProperty("审查员")
	private List<AppShowJudge> appShowJudges;
	//场馆位置
	@ApiModelProperty("场馆信息")
	private AppHandlerVenue appHandlerVenue;
	@ApiModelProperty("酒店住宿")
	private AppCkuHotel appCkuHotel;
	@ApiModelProperty("是否可以报名")
	private boolean flag=false;	//是否可以报名
	@ApiModelProperty("活动类型：5训犬师考试/6训犬师比赛")
	private String showType; // 活动类型
	@ApiModelProperty("赛事编号")
	private String showCode; // 赛事编号
	//赛事规范

}