package com.cku.oa.groomer.web;

import java.io.IOException;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ResultDto;
import com.cku.core.ZAException;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.GroomerMemberService;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.oa.trainschool.service.TrainingInstitutionService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 美容师会员信息 user chaixueteng 2016年7月19日
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/groomerMember")
public class GroomerMemberController extends BaseController {

	@Autowired
	public GroomerMemberService groomerMemberService;

	@Autowired
	public TrainingInstitutionService trainingInstitutionService;

	@ModelAttribute
	public Member get(@RequestParam(required = false) String id) {
		Member entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = groomerMemberService.get(id);
		}
		if (entity == null) {
			entity = new Member();
		}
		return entity;
	}

	@RequiresPermissions("groomer:groomerMember:view")
	@RequestMapping(value = { "list", "" })
	public String list(Member member, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<Member> page = groomerMemberService.findPage(new Page<Member>(request, response), member);
		request.setAttribute("date", new Date());
		model.addAttribute("page", page);
		return "oa/groomer/groomerMemberList";
	}

	@RequiresPermissions("groomer:groomerMember:view")
	@RequestMapping(value = "form")
	public String form(Member member, Model model) {
		model.addAttribute("member", member);
		model.addAttribute("province", UserUtils.getProvince());
		model.addAttribute("city", UserUtils.getCityByProvince(member.getProvince()));
		return "oa/groomer/groomerMemberForm";
	}

	@RequiresPermissions("groomer:groomerMember:view")
	@RequestMapping(value = "view")
	public String view(Member member, Model model) {
		model.addAttribute("member", member);
		model.addAttribute("province", UserUtils.getProvince());
		model.addAttribute("city", UserUtils.getCityByProvince(member.getProvince()));
		return "oa/groomer/groomerMemberView";
	}

	@RequiresPermissions("groomer:groomerMember:modifyClub")
	@RequestMapping(value = "modifyClubView", method = RequestMethod.GET)
	public String modifyClubView(Member member, Model model) {
		List<TrainingInstitution> groomerSchoolList = trainingInstitutionService
				.findGroomerSchoolList(new TrainingInstitution());
		model.addAttribute("member", member);
		model.addAttribute("groomerSchoolList", groomerSchoolList);
		return "oa/groomer/groomerMemberModifyClubView";
	}

	@RequiresPermissions("groomer:groomerMember:modifyClub")
	@RequestMapping(value = "modifyClub", method = RequestMethod.POST)
	@ResponseBody
	public ResultDto<Boolean> modifyClub(Member member, Model model) {
		//防止特殊字符转义
		member.setCkuClub(StringEscapeUtils.unescapeHtml4(member.getCkuClub()));
		if ("1".equals(member.getRegistrantModifyFlag())) {
			member.setRegistrant(member.getCkuClub());
		}
		groomerMemberService.updateGroomerMemberClub(member);
		return ResultDto.success(Boolean.TRUE);
	}

	/**
	 * 根据会员号查询会员培训经历
	 * 
	 * @throws ZAException
	 * @Author chaixueteng
	 * @2016年7月19日下午3:15:14
	 */
	@RequestMapping(value = "/getMemberExperience")
	public void getMemberMessage(HttpServletRequest request, HttpServletResponse response) throws ZAException {
		String memberCode = request.getParameter("memberCode");
		try {
			response.setContentType("text/Xml;charset=utf-8");
			String str = groomerMemberService.getMemberExperience(memberCode);
			response.getWriter().write(str);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	@RequiresPermissions("groomer:groomerMember:edit")
	@RequestMapping(value = "updateGroomerMember")
	public String updateGroomerMember(Member member, Model model, RedirectAttributes redirectAttributes) {
		groomerMemberService.updateGroomerMember(member);
		return "redirect:" + Global.getAdminPath() + "/groomer/groomerMember/?repage";
	}

	/**
	 * 正式会员卡打印
	 * 
	 * @Author chaixueteng
	 * @2016年11月1日下午1:42:37
	 */
	@RequestMapping(value = "groomerMemberPrint")
	public String groomerMemberPrint(Member member, Model model, RedirectAttributes redirectAttributes) {
		Member member2 = groomerMemberService.groomerMemberPrint(member);
		model.addAttribute("member", member2);
		return "oa/groomer/groomerMemberPrint";
	}

	/**
	 * 正式会员卡重置打印
	 * 
	 * @Author chaixueteng
	 * @2016年11月1日下午1:42:37
	 */
	@RequestMapping(value = "restPrint")
	public String restPrint(Member member, Model model, RedirectAttributes redirectAttributes) {
		groomerMemberService.updatePrint(member);
		return "redirect:" + Global.getAdminPath() + "/groomer/groomerMember/?repage";
	}

	/**
	 * 导入会员号 导出相关信息
	 * 
	 * @Author chaixueteng
	 * @2018年04月20日下午1:42:37
	 */
	@RequestMapping(value = "import", method = RequestMethod.POST)
	public String importFile(MultipartFile file, HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			// 赛事信息导入
			groomerMemberService.importShows(file, response);
			addMessage(redirectAttributes, "导入成功！");
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入失败！失败信息：" + e.getMessage());
			return "redirect:" + Global.getAdminPath() + "/groomer/groomerMember/?repage";
		}
		return null;
	}
}
