package com.cku.oa.gcWeb.entity;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * 美容官网轮播图Entity
 *
 * @author yuanshuai
 * @version 2023-01-31
 */
public class GCWebBanner extends DataEntity<GCWebBanner> {

	private static final long serialVersionUID = 1L;
	private String title;        // 标题
	private String image;        // 图片
	private String smallImage;        // 小图(手机适配用)
	private Integer showFlag;        // 显示标记（0不显示1显示）
	private Integer sort;        // 排序

	public GCWebBanner() {
		super();
	}

	public GCWebBanner(String id) {
		super(id);
	}

	@Length(min = 1, max = 64, message = "标题长度必须介于 1 和 64 之间")
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	@Length(min = 0, max = 255, message = "图片长度必须介于 0 和 255 之间")
	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	@Length(min = 0, max = 255, message = "小图(手机适配用)长度必须介于 0 和 255 之间")
	public String getSmallImage() {
		return smallImage;
	}

	public void setSmallImage(String smallImage) {
		this.smallImage = smallImage;
	}

	@NotNull(message = "显示标记（0不显示1显示）长度必须介于 1 和 4 之间")
	public Integer getShowFlag() {
		return showFlag;
	}

	public void setShowFlag(Integer showFlag) {
		this.showFlag = showFlag;
	}

	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

}