package com.cku.oa.finance.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.core.ZAException;
import com.cku.oa.finance.entity.PaymentOnAccount;
import com.cku.oa.finance.service.PaymentOnAccountService;

/**
 * 资金挂账Controller
 * @author lyy
 * @version 2016-08-16
 */
@Controller
@RequestMapping(value = "${adminPath}/finance/paymentOnAccount")
public class PaymentOnAccountController extends BaseController {

	@Autowired
	private PaymentOnAccountService paymentOnAccountService;
	
	@ModelAttribute
	public PaymentOnAccount get(@RequestParam(required=false) String id) {
		PaymentOnAccount entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = paymentOnAccountService.get(id);
		}
		if (entity == null){
			entity = new PaymentOnAccount();
		}
		return entity;
	}
	
	@RequiresPermissions("finance:paymentOnAccount:view")
	@RequestMapping(value = {"list", ""})
	public String list(PaymentOnAccount paymentOnAccount, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<PaymentOnAccount> page = paymentOnAccountService.findPage(new Page<PaymentOnAccount>(request, response), paymentOnAccount); 
		model.addAttribute("page", page);
		return "oa/finance/paymentOnAccountList";
	}

	@RequiresPermissions("finance:paymentOnAccount:view")
	@RequestMapping(value = "form")
	public String form(PaymentOnAccount paymentOnAccount, Model model) {
		model.addAttribute("paymentOnAccount", paymentOnAccount);
		return "oa/finance/paymentOnAccountForm";
	}

	@RequiresPermissions("finance:paymentOnAccount:changeAccount")
	@RequestMapping(value = "toChange")
	public String toChange(PaymentOnAccount paymentOnAccount, Model model) {
		model.addAttribute("paymentOnAccount", paymentOnAccount);
		return "oa/finance/paymentOnAccountChange";
	}

	@RequiresPermissions("finance:paymentOnAccount:changeAccount")
	@RequestMapping(value = "changeAccount")
	public String changeAccount(PaymentOnAccount paymentOnAccount, Model model, RedirectAttributes redirectAttributes) {
		try {
			paymentOnAccountService.changeAccount(paymentOnAccount);
		} catch (ZAException e) {
			addMessage(redirectAttributes,e.getMessage());
			return "redirect:"+Global.getAdminPath()+"/finance/paymentOnAccount/toChange?id="+paymentOnAccount.getId();
		}
		addMessage(redirectAttributes, "资金挂账转入成功");
		return "redirect:"+Global.getAdminPath()+"/finance/paymentOnAccount/?repage";
	}
	@RequiresPermissions("finance:paymentOnAccount:add")
	@RequestMapping(value = "save")
	public String save(PaymentOnAccount paymentOnAccount, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, paymentOnAccount)){
			return form(paymentOnAccount, model);
		}
		paymentOnAccountService.saveOnAccount(paymentOnAccount);
		addMessage(redirectAttributes, "保存资金挂账成功");
		return "redirect:"+Global.getAdminPath()+"/finance/paymentOnAccount/?repage";
	}
	
//	@RequiresPermissions("finance:paymentOnAccount:edit")
//	@RequestMapping(value = "delete")
//	public String delete(PaymentOnAccount paymentOnAccount, RedirectAttributes redirectAttributes) {
//		paymentOnAccountService.delete(paymentOnAccount);
//		addMessage(redirectAttributes, "删除资金挂账成功");
//		return "redirect:"+Global.getAdminPath()+"/finance/paymentOnAccount/?repage";
//	}

}