package com.cku.oa.breeder.web;

import com.cku.oa.breeder.entity.Whitelist;
import com.cku.oa.breeder.service.WhitelistService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 白名单表Controller
 *
 * @author lgl
 * @version 2018-01-16
 */
@Controller
@RequestMapping(value = "${adminPath}/whitelist/whitelist")
public class WhitelistController extends BaseController {

    @Autowired
    private WhitelistService whitelistService;

    @ModelAttribute
    public Whitelist get(@RequestParam(required = false) String id) {
        Whitelist entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = whitelistService.get(id);
        }
        if (entity == null) {
            entity = new Whitelist();
        }
        return entity;
    }

    @RequiresPermissions("whitelist:whitelist:view")
    @RequestMapping(value = {"list", ""})
    public String list(Whitelist whitelist, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<Whitelist> page = whitelistService.findPage(new Page<Whitelist>(request, response), whitelist);
        model.addAttribute("page", page);
        return "breeder/whitelist/whitelistList";
    }

    @RequiresPermissions("whitelist:whitelist:view")
    @RequestMapping(value = "form")
    public String form(Whitelist whitelist, Model model) {
        model.addAttribute("whitelist", whitelist);
        return "breeder/whitelist/whitelistForm";
    }

    @RequiresPermissions("whitelist:whitelist:edit")
    @RequestMapping(value = "save")
    public String save(Whitelist whitelist, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, whitelist)) {
            return form(whitelist, model);
        }
        whitelistService.save(whitelist);
        addMessage(redirectAttributes, "保存白名单表成功");
        return "redirect:" + Global.getAdminPath() + "/whitelist/whitelist/?repage";
    }

    @RequiresPermissions("whitelist:whitelist:edit")
    @RequestMapping(value = "delete")
    public String delete(Whitelist whitelist, RedirectAttributes redirectAttributes) {
        whitelistService.delete(whitelist);
        addMessage(redirectAttributes, "删除白名单表成功");
        return "redirect:" + Global.getAdminPath() + "/whitelist/whitelist/?repage";
    }

}