package com.cku.oa.breeder.web;

import com.cku.oa.breeder.entity.Blacklist;
import com.cku.oa.breeder.service.BlacklistService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 黑名单表Controller
 *
 * @author lgl
 * @version 2018-01-16
 */
@Controller
@RequestMapping(value = "${adminPath}/blacklist/blacklist")
public class BlacklistController extends BaseController {

    @Autowired
    private BlacklistService blacklistService;

    @ModelAttribute
    public Blacklist get(@RequestParam(required = false) String id) {
        Blacklist entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = blacklistService.get(id);
        }
        if (entity == null) {
            entity = new Blacklist();
        }
        return entity;
    }

    @RequiresPermissions("blacklist:blacklist:view")
    @RequestMapping(value = {"list", ""})
    public String list(Blacklist blacklist, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<Blacklist> page = blacklistService.findPage(new Page<Blacklist>(request, response), blacklist);
        model.addAttribute("page", page);
        return "breeder/blacklist/blacklistList";
    }

    @RequiresPermissions("blacklist:blacklist:view")
    @RequestMapping(value = "form")
    public String form(Blacklist blacklist, Model model) {
        model.addAttribute("blacklist", blacklist);
        return "breeder/blacklist/blacklistForm";
    }

    @RequiresPermissions("blacklist:blacklist:edit")
    @RequestMapping(value = "save")
    public String save(Blacklist blacklist, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, blacklist)) {
            return form(blacklist, model);
        }
        blacklistService.save(blacklist);
        addMessage(redirectAttributes, "保存黑名单表成功");
        return "redirect:" + Global.getAdminPath() + "/blacklist/blacklist/?repage";
    }

    @RequiresPermissions("blacklist:blacklist:edit")
    @RequestMapping(value = "delete")
    public String delete(Blacklist blacklist, RedirectAttributes redirectAttributes) {
        blacklistService.delete(blacklist);
        addMessage(redirectAttributes, "删除黑名单表成功");
        return "redirect:" + Global.getAdminPath() + "/blacklist/blacklist/?repage";
    }

}