package com.cku.catx.dog.web;

import com.cku.catx.dog.service.CATXDogOwnerChangeService;
import com.cku.catx.dog.vo.DogOwnerChangeVo;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.oa.dog.entity.DogOwnerChange;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 2021年3月2日17:35:55
 */
@Controller
@RequestMapping(value = "${adminPath}/catx/dog/dogOwnerChange")
public class CATXDogOwnerChangeController extends BaseController {

	@Autowired
	private CATXDogOwnerChangeService catxDogOwnerChangeService;

	@ModelAttribute
	public DogOwnerChange get(@RequestParam(required = false) String id) {
		DogOwnerChange entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = catxDogOwnerChangeService.get(id);
		}
		if (entity == null) {
			entity = new DogOwnerChange();
		}
		return entity;
	}


	@RequiresPermissions("catx:dogOwnerChange:view")
	@RequestMapping(value = {"list", ""})
	public String list(DogOwnerChange dogOwnerChange, HttpServletRequest request, HttpServletResponse response,
					   Model model) {
		//只查询当前登录会员犬只
		dogOwnerChange.setCreateBy(UserUtils.getLoginUser());
		Page<DogOwnerChange> page = catxDogOwnerChangeService.findPage(new Page<>(request, response), dogOwnerChange);
		model.addAttribute("page", page);
		return "oa/catx/dog/dogOwnerChange/dogOwnerChangeList";
	}


	@RequiresPermissions("catx:dogOwnerChange:add")
	@RequestMapping(value = "addForm")
	public String addFrom(DogOwnerChange dogOwnerChange, Model model) {
		model.addAttribute("dogOwnerChange", dogOwnerChange);
		return "oa/catx/dog/dogOwnerChange/dogOwnerChangeAddForm";
	}

	@RequiresPermissions("catx:dogOwnerChange:add")
	@RequestMapping(value = "add")
	@ResponseBody
	public ResultDto<String> add(DogOwnerChange dogOwnerChange) {
		try {
			restBeanValidator(dogOwnerChange);
			catxDogOwnerChangeService.save(dogOwnerChange);
		} catch (Exception e) {
			e.printStackTrace();
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, "保存犬主变更失败：" + e.getMessage());
		}
		return ResultDto.success("保存犬主变更成功");
	}

	@RequiresPermissions("catx:dogOwnerChange:delete")
	@RequestMapping(value = "delete")
	public String delete(DogOwnerChange dogOwnerChange, RedirectAttributes redirectAttributes) {
		try {
			catxDogOwnerChangeService.delete(dogOwnerChange);
			addMessage(redirectAttributes, "删除成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "删除失败：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/catx/dog/dogOwnerChange/?repage";
	}

	@RequiresPermissions("catx:dogOwnerChange:add")
	@RequestMapping(value = "info/{identificationFlag}")
	@ResponseBody
	public ResultDto<DogOwnerChangeVo> getDogByIdentificationFlag(@PathVariable("identificationFlag") String identificationFlag) {
		DogOwnerChangeVo vo;
		try {
			vo = catxDogOwnerChangeService.getDogByIdentificationFlag(identificationFlag);
		} catch (Exception e) {
			e.printStackTrace();
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, e.getMessage());
		}
		return ResultDto.success(vo);
	}

}