<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬舍管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
			
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出犬舍数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/kennel/kennel/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctxDc}/kennel">犬舍列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="kennel" action="${ctxDc}/kennel" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号/姓名：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>犬舍中/英文名：</label>
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>fci犬舍英文名：</label>
				<form:input path="fciName" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>fci犬舍编号：</label>
				<form:input path="fciKennelCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li>
				<label>犬舍类型：</label>
				<form:select path="type" class="input-small">
					<form:option value="">全部</form:option>
					<form:option value="year" label="年度犬舍"/>
					<form:option value="permanent" label="永久犬舍"/>
					<form:option value="Fci" label="FCI犬舍"/>
				</form:select>
			</li>
			<li><label>缴费状态：</label>
				<form:select path="paymentState" class="input-small">
					<form:option value="all">全部</form:option>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li> 
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>FCI审核状态：</label>
				<form:select path="fciReviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('fci_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>中文名打印状态：</label>
				<form:select path="printState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('print_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li> 
			<li><label>FCI打印状态：</label>
				<form:select path="fciPrintState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('fci_print_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li> 
			<li><label>犬舍核算状态：</label>
				<form:select path="calculationState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('calculation_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li>
				<label>申请日期：</label>
				<input name="beginDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${kennel.beginDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${kennel.endDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns">				
				<shiro:hasPermission name="kennel:kennel:export"><button id="btnExport" type="button" class="btn btn-primary" >导出当月新注册FCI</button></shiro:hasPermission>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员号</th>
				<th>姓名</th>
				<th>英文名</th>
				<th>犬舍编号</th>
				<th>犬舍中文名</th>
				<th>犬舍英文名</th>
				<th>FCI犬舍编号</th>
				<th>FCI犬舍名称</th>
				<th>登记日期</th>
				<th>犬舍截止日期</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="kennel">
			<tr>
				<td>
					${fns:escapeHtml(kennel.memberCode)}
				</td>
				<td>
					${fns:escapeHtml(kennel.member.name)}
				</td>
				<td>
					${fns:escapeHtml(kennel.member.nameEn)}
				</td>
				<td>
					${fns:escapeHtml(kennel.kennelCode)}
				</td>
				<td>
					${fns:escapeHtml(kennel.name)}
				</td>
				<td>
					${kennel.nameEn}
				</td>
				<td>
					${fns:escapeHtml(kennel.fciKennelCode)}
				</td>
				<td>
					${kennel.fciName}
				</td>
				<td>
					<fmt:formatDate value="${kennel.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${kennel.endTime}" pattern="yyyy-MM-dd"/>
					<c:choose>
						<c:when test="${kennel.endTime >= date }">
							<font color="greed">已缴费</font>
						</c:when>
						<c:otherwise>
							<font color="red">未缴费</font>
						</c:otherwise>
					</c:choose>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>