<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>新生犬登记管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function openViewPage(id,birthCode,dogOwenr,createDate,hospitalCode){
            parent.layer.open({
                type: 2,
                title: ['新生犬登记查看', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['560px', '480px'],
                content: ctxDc+"/dogChip/view?id="+id,
                end: function(){
                    if(parent.isYes){
                        var mainF = parent.$("#mainFrame");
                        mainF.contents().find("#searchForm").submit();
                    };
                }
            }); 
        };
	</script>
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
    <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctxDc}/dogChip">新生犬登记列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogChip" action="${ctxDc}/dogChip" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>出生纸编号：</label>
				<form:input path="birthCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>芯片号：</label>
				<form:input path="identificationFlag" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员号/姓名：</label>
				<form:input path="dogBirthCertificate.dogOwenr" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>合作医院：</label>
			    <form:input path="sysOrg.name" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
            <li><label>审核状态：</label>
                <form:select path="reviewState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
            <li><label>付款状态：</label>
                <form:select path="paymentState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
            <li><label>申请时间：</label>
                <input name="createDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogChip.createDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>-
                    <input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogChip.endDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
            </li>
            <li><label>芯片注入时间：</label>
                <input name="chipInjectDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogChip.chipInjectDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>-
                    <input name="endInjectDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogChip.endInjectDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
            </li>
            <li><label>撤销时间：</label>
                <input name="canceledDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogChip.canceledDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>-
                    <input name="canceledEndDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogChip.canceledEndDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
            </li>
            <li><label>撤销状态：</label>
                <form:select path="isCanceled" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('canceled_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
			<li><label>处理时间：</label>
				<input name="processStartDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${dogChip.processStartDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>-
				<input name="processEndDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${dogChip.processEndDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
            <li><label>处理人：</label>
                <form:select path="processUserId" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:option value="105412" label="张永祺"/>
                </form:select>
            </li>
            <li><label>打印状态：</label>
                <form:select path="printState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:option value="2" label="未打印"/>
                    <form:option value="02" label="已打印"/>
                </form:select>
            </li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>出生纸编号</th>
				<th>犬主</th>
				<th>申请时间</th>
				<th>申请医院</th>
				<th>血统证书号</th>
				<th>芯片号</th>
				<th>操作人</th>
				<th>流水号</th>
				<th>付款状态</th>
				<th>审核状态</th>
				<th>处理状态</th>
				<th>撤销状态</th>
				<th>撤销时间</th>
				<th>业务状态</th>
				<th>操作</th>
				<th>打印</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogChip">
			<tr>
				<td>
					${fns:escapeHtml(dogChip.birthCode) }
				</td>
				<c:if test="${not empty dogChip.dogBirthCertificate.tempMemberCode}">
					<td title="${dogChip.dogBirthCertificate.tempMemberCode}">
							${fns:escapeHtml(dogChip.dogBirthCertificate.tempUserName) }
					</td>
				</c:if>
				<c:if test="${empty dogChip.dogBirthCertificate.tempMemberCode}">
					<td title="${dogChip.dogBirthCertificate.memberCode}">
							${fns:escapeHtml(dogChip.dogBirthCertificate.dogOwenr) }
					</td>
				</c:if>
				<td>
                    <fmt:formatDate value="${dogChip.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
                </td>
                <td>
                    ${fns:escapeHtml(dogChip.sysOrg.name) }
                </td>
                <td>
                    ${fns:escapeHtml(dogChip.dogBirthCertificate.pedigreeCertified) }
                </td>
                <td>
                    ${fns:escapeHtml(dogChip.dogBirthCertificate.identificationFlag) }
                </td>
				<td>
					${fns:escapeHtml(dogChip.dogBirthCertificate.addUser) }
				</td>
				<td>
					${fns:escapeHtml(dogChip.runningNumber) }
				</td>
				<td>
				    <c:if test="${dogChip.paymentState==1}"><font color="red">${fns:getDictLabel(dogChip.paymentState, 'user_payment_state', '')}</font></c:if>
				    <c:if test="${dogChip.paymentState==2}"><font color="green">${fns:getDictLabel(dogChip.paymentState, 'user_payment_state', '')}</font></c:if>
				</td>
				<td title="${fns:escapeHtml(dogChip.reviewRemarks) }">
				    ${fns:getDictLabel(dogChip.reviewState, 'review_state', '')}</font></a>
                </td>
                <td>
                ${fns:getDictLabel(dogChip.processState, 'proccess_state', '')}
                </td>
                <td>
                    <c:if test="${'1' eq dogChip.isCanceled}">已撤销</c:if>
                    <c:if test="${dogChip.isCanceled!='1'}">
                    		正常
                    </c:if>
                </td>
                <td>
                    <fmt:formatDate value="${dogChip.delTime}" pattern="yyyy-MM-dd"/>
                </td>
				<td>
					${dogChip.businessState}
				</td>
                <td>
                    <a onclick="openViewPage('${dogChip.id}','${dogChip.birthCode}','${dogChip.dogBirthCertificate.dogOwenr}','${dogChip.createDate}','${dogChip.hospitalCode}')" href="#">查看</a>

				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>