<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>繁育证书管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
    <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctxDc}/dogBreedCertified">繁育证书列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogBreedCertified" action="${ctxDc}/dogBreedCertified" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>血统/繁育证书号：</label>
				<form:input path="breedCertifiedCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>会员号/姓名：</label>
                <form:input path="dog.dogOwner" htmlEscape="false" maxlength="100" class="input-medium"/>
            </li>
			<li><label>审核状态：</label>
                <form:select path="reviewState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
            <li><label>付款状态：</label>
                <form:select path="paymentState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
			<li><label>处理状态：</label>
				<form:select path="processState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('proccess_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>申请时间：</label>
                <input name="createDate" type="text"  maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogBreedCertified.createDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>-
                    <input name="endDate" type="text"  maxlength="20" class="input-medium Wdate"
                    value="<fmt:formatDate value="${dogBreedCertified.createDate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
            </li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
			    <th>血统证书号</th>
				<th>繁育证书编号</th>
				<th>犬主人</th>
				<th>申请日期</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>处理状态</th>
				<th>打印状态</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogBreedCertified">
			<tr>
			    <td>
			        ${fns:escapeHtml(dogBreedCertified.dog.pedigreeCertifiedCode) }
			    </td>
				<td>
				    ${fns:escapeHtml(dogBreedCertified.breedCertifiedCode) }
				</td>
				<td style="color: #000" title="${fns:escapeHtml(dogBreedCertified.dog.memberCode) }">
                    ${fns:escapeHtml(dogBreedCertified.dog.dogOwner) }
                </td>
				<td>
					<fmt:formatDate value="${dogBreedCertified.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<c:if test="${dogBreedCertified.paymentState==1}"><font color="red">${fns:getDictLabel(dogBreedCertified.paymentState, 'user_payment_state', '')}</font></c:if>
                    <c:if test="${dogBreedCertified.paymentState==2}"><font color="green">${fns:getDictLabel(dogBreedCertified.paymentState, 'user_payment_state', '')}</font></c:if>
				</td>
				<td title="${dogBreedCertified.reviewRemarks}">
					   ${fns:getDictLabel(dogBreedCertified.reviewState, 'review_state', '')}
                </td>
				<td>
					${fns:getDictLabel(dogBreedCertified.processState, 'proccess_state', '')}
				</td>
				<td>
				    ${fns:getDictLabel(dogBreedCertified.printState, 'print_state', '-')}
				</td>
				<td>
				<a href="${ctxDc}/dogBreedCertified/form?id=${fns:escapeHtml(dogBreedCertified.id) }">查看</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>