<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>DNA双亲比对管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dogdnaparentscompare/dogDnaParentsCompare/">DNA双亲比对列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogDnaParentsCompare" action="${ctx}/dogdnaparentscompare/dogDnaParentsCompare/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>出生纸/证书号：</label>
				<form:input path="birthCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员号/姓名：</label>
			<form:input path="paymentMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>订单状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>申请日期：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogDnaParentsCompare.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogDnaParentsCompare.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>出生纸编号</th>
				<th>血统证书编号</th>
				<th>犬主</th>
				<th>父血统证书号</th>
				<th>母血统证书号</th>
				<th>申请日期</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>撤销状态</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogDnaParentsCompare">
			<tr>
				<td>
					${dogDnaParentsCompare.birthCode}
				</a>
				</td>
				<td>
					${dogDnaParentsCompare.pedigreeCertified}
				</td>
				<td>
					${dogDnaParentsCompare.name}
				</td>
				<td>
					${dogDnaParentsCompare.fdogPedigreeCertified}
				</td>
				<td>
					${dogDnaParentsCompare.mdogPedigreeCertified}
				</td>
				<td>
					<fmt:formatDate value="${dogDnaParentsCompare.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td style="color:${dogDnaParentsCompare.paymentState=='2'?'#090':'#F00'}">
						${fns:getDictLabel(dogDnaParentsCompare.paymentState, 'user_payment_state', '')}
				</td>
				<td>
					<c:if test="${dogDnaParentsCompare.paymentState==2}">
						<c:choose>
						<c:when test="${dogDnaParentsCompare.reviewState==0||dogDnaParentsCompare.reviewState==2}">
								${fns:getDictLabel(dogDnaParentsCompare.reviewState, 'review_state', '')}
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(dogDnaParentsCompare.reviewState, 'review_state', '')}
						</c:otherwise>
						</c:choose>
					</c:if>
				</td>
				<td>
					<c:if test="${dogDnaParentsCompare.isCanceled=='1'}">
						已撤销
					</c:if>
				</td>
				<td>
					<a href="${ctxDc}/dogDnaParentsCompare/form?id=${dogDnaParentsCompare.id}" >查看</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>