<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容师结业证书管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(function () {
			if(${teacherLecturer.avatar!=null}){
				$("#avatarPreview").attr("src",'/oa-web/schools/file/image/${teacherLecturer.avatar}');
				$("#avatar").val('${teacherLecturer.avatar}');
			}
		});
		$(document).ready(function() {
			//查重
			$("#teacherIndex").blur(function () {
				var rotationIndex = $("#rotationIndex").val();
				$.ajax({
					url:'${ctxSchools}/schoolsTeacher/iSrepeat',
					data: {rotationIndex:rotationIndex},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc!=0){
							layer.msg(json.msg);
						}
					}
				});
			});
			$("#btnSubmit").click(function(){

				if ($("#teacherName").val() == "") {
					alert("讲师姓名不能为空");
					return false;
				}
				var tel = $("#tel").val();
				if ($("#tel").val() == "") {
					alert("手机号不能为空");
					return false;
				}
				var pattern = /^1[123456789]\d{9}$/;
				if(!pattern.test(tel)){
					alert("请填写正确的手机号");
					return false;
				}

				if ($("#avatar").val() == "") {
					alert("讲师头像不能为空");
					return false;
				}
				if ($("#introduce").val() == "") {
					alert("详细介绍不能为空");
					return false;
				}
				var arry = new Array();
				$('input[name="level"]:checked').each(function(index, element) {
					//追加到数组中
					arry.push($(this).val());
				});
				if (arry == "") {
					alert("请填写授课等级!!!");
					return false;
				}
				$("#inputForm").submit();
			});


		});



	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
<ul class="nav nav-tabs">
	<li class="active"><a href="#">当前位置:讲师管理</a></li>
</ul>
<br>
<div style="margin-top: 20px;margin-bottom: 20px;">
	<label><strong>讲师列表</strong></label>
	<span  style="float:right;"><input id="btnCancel" class="btn btn-primary" type="button" value="返 回" onclick="history.go(-1)"/></span>
</div>
	<form:form id="inputForm" modelAttribute="teacherLecturer" action="${ctxSchools}/schoolsTeacher/save" method="post" class="form-horizontal">
		<sys:message content="${message}"/>
		<form:input path="id" id="id" type="hidden" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
		<div class="control-group">
			<label class="control-label">讲师姓名：</label>
			<div class="controls">
				<form:input path="teacherName"   htmlEscape="false" maxlength="100" class="input-xlarge required" placeholder="请输入讲师姓名"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">联系方式：</label>
			<div class="controls">
				<form:input path="tel"  htmlEscape="false" maxlength="100" class="input-xlarge required" placeholder="请输入讲师手机号 "/>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="control-group" style="width:80%">
			<label class="control-label">讲师头像：</label>
			<div class="controls">
				<div class="file-portrait">
					<img id="avatarPreview" style="max-width:117px;max-height:150px;background-color: antiquewhite;border: 1px solid;" onclick="uploadImg()" src="${ctxStatic}/images/head.png">
				</div>
				<p><a id="uploadImg" href="javascript:;" onclick="uploadImg()">点击上传讲师头像</a></p>
				<form:input path="avatar" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						$("#avatar").val(response.id);
					}
					function uploadImg(){
						layer.open({
							type: 2,
							title: '讲师头像上传',
							shadeClose: true,
							shade: 0.8,
							area: ['480px', '340px'],
							content:'${ctxSchools}/file/uploadPage'
						});
					}
				</script>
				<span style="color:red;">只能上传jpg/png文件，且不超过500kb </span>
			</div>
		</div>

		<div style = "clear:both;"/>
		<div class="control-group">
			<label class="control-label">授课等级：</label>
			<div class="controls">
				<input type="checkbox" name="level" value="A" id="level1">A级
				<input type="checkbox" name="level" value="B"  id="level2">B级
				<input type="checkbox" name="level" value="C"  id="level3">C级
				<span class="help-inline"><font color="red">*</font></span>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="control-group">
			<label class="control-label">详细介绍：</label>
			<div class="controls">
				<form:textarea path="introduce"  htmlEscape="false" rows="4" maxlength="200" class="input-xxlarge " placeholder="请输入内容，200字以内"/>
			</div>
		</div>
		<%--<div class="control-group">--%>
			<%--<label class="control-label">讲师编号：</label>--%>
			<%--<div class="controls">--%>
				<%--<form:input path="teacherIndex"  min="1" type="number" htmlEscape="false" maxlength="64" class="input-xlarge "/>--%>
			<%--</div>--%>
		<%--</div>--%>
		<%--<div style = "clear:both;"></div>--%>
		<div style = "clear:both;"></div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="button" onclick="submit1()" value="保 存"/>&nbsp;
			<input class="btn" type="button" value="取消" onclick="history.go(-1)"/>
		</div>
	</form:form>
<script>
	$(function () {

		if(${teacherLecturer.level!=null}){
			var arr=new Array();
			arr = "${teacherLecturer.level}".split(",");
			for(var i=0;i<arr.length;i++){
				if(arr[i]=="A"){
					$("#level1").attr("checked",'true');
				}
				if(arr[i]=="B"){
					$("#level2").attr("checked",'true');
				}
				if(arr[i]=="C"){
					$("#level3").attr("checked",'true');
				}
			}
		}
	});
</script>
</body>
</html>