<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>出生证明管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
			resetTip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function birthCode(){
			layer.open({
	            type: 1,
	            title: "请输入登记卡编号",
	            shadeClose: true,
	            area: ['300px', '180px'],
	            content: '<form id="birthForm" action="${ctxPartner}/tcbDog/validBirthCode">'
	            +'<div style="margin:10px auto;width:215px;height:55px;">'+
	            '<span>登记卡编号  :</span><input type="text" id="birthCode" name="birthCode" ></span></div></form>'
	            ,btn: ['确定', '取消']
	    		,yes: function(index){
	    			var a = $("#birthCode").val();
	    			if(a!=''){
	    				$("#birthForm").submit();
			            }
	    		}
			});		
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a>血统证书管理</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogBirthCertificate" action="${ctxPartner}/tcbDog/dogList" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>登记卡编号：</label>
				<form:input path="birthCerRegCode" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>血统证书号：</label>
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
		</ul>
		<ul class="ul-form">
			<li><label>申请时间：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogBirthCertificate.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogBirthCertificate.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<%--	<li class="btns" style="float:right"><button  class="btn btn-primary" type="button" onclick="birthCode()" >新申请血统证书</button></li>
			--%>
			<li class="clearfix"></li>
		</ul>	
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>登记卡编号</th>
				<th>血统证书号</th>
				<th>申请日期</th>
				<th>办理日期</th>
				<th>操作</th>
				<th>打印</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogBirthCertificate">
			<tr>
				<td>
					${fns:escapeHtml(dogBirthCertificate.birthCerRegCode)}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.pedigreeCertified)}
				</td>
				<td>
					<fmt:formatDate value="${dogBirthCertificate.dogChip.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<fmt:formatDate value="${dogBirthCertificate.dogChip.processTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<c:choose>
						<c:when test="${dogBirthCertificate.dogChip.paymentState=='2' && dogBirthCertificate.dogChip.processState=='0' && empty dogBirthCertificate.pedigreeCertified}">
							<a style="color:red;"  href="${ctxPartner}/clubMember/dogChipHandleForm?birthCode=${dogBirthCertificate.birthCerRegCode}">办理</a>
						</c:when>
						<c:when test="${dogBirthCertificate.dogChip.paymentState=='2' && dogBirthCertificate.dogChip.processState =='1' && not empty dogBirthCertificate.pedigreeCertified }">
							<font style="color:green;">已办理</font>
						</c:when>
					</c:choose>
				</td>
				<td>
					<c:if test="${dogBirthCertificate.dogChip.paymentState=='2' }">
				    	<c:if test="${dogBirthCertificate.printType=='2' && not empty dogBirthCertificate.pedigreeCertified}">
				    			<a href="${ctxPartner}/clubMember/print?pedigreeCertified=${dogBirthCertificate.pedigreeCertified}" onclick="return confirmx('确认要打印吗？', this.href)">打印</a>
				    	</c:if>
					</c:if>
				   	 <c:if test="${fn:length(dogBirthCertificate.printType)==2&&fn:startsWith(dogBirthCertificate.printType,'0')}">
						<font color="green">已打印</font>
					</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>