<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展成绩管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			//给裁判下拉框赋值
			$('#s2id_referee').find('.select2-chosen').html('${fns:escapeHtml(showResults.referee)}');
			$("#referee").prepend("<option value='${fns:escapeHtml(showResults.referee)}' selected='selected'>${fns:escapeHtml(showResults.referee)}</option>");

		});
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
	<style type="text/css">
		.form-horizontal .control-label{
			width: 120px;
		}
	</style>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/results/showResults/">犬展成绩列表</a></li>
		<li class="active"><a href="${ctx}/results/showResults/form?id=${showResults.id}">犬展成绩<shiro:hasPermission name="results:showResults:edit">${not empty showResults.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="results:showResults:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="showResults" action="${ctx}/results/showResults/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">秩序号：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.orderCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.pedigreeCertified)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">评价：</label>
			<div class="controls">
					${fns:escapeHtml(showResults.appraisal)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">CC：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.resultCc)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">CC备注：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.remarksCc)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">CACIB：</label>
			<div class="controls">
				${fns:getDictLabel(showResults.resultCacib, 'show_result_cacib', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">CACIB备注：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.remarksCacib)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BOB：</label>
			<div class="controls">
				${fns:getDictLabel(showResults.resultBob, 'show_result_bob', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BOV：</label>
			<div class="controls">
				${showResults.resultBov}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BOW：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.resultBow)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BOJ/JBOS/VBOB：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.resultBoj)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BIG：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.resultBig)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BIS：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.resultBis)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BBE-BIS：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.resultBbeBis)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BBE-BIG：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.resultBbeBig)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BBE-BISS：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.resultBbeBiss)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BBE-WINNER：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.resultBbeWinner)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">OHC-BIS：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.resultOhcBis)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">OHC-BIG：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.resultOhcBig)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">OHC-BISS：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.resultOhcBiss)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">OHC-BOH：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.resultOhcBoh)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">本场积分：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.showResult)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">单犬种积分：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.showBreedResult)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">OHC积分：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.ohcScore)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BBE积分：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.showResult)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label"> WW/APCS-CAC：</label>
			<div class="controls">
					${fns:escapeHtml(showResults.resultApaccc)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主中文名：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.dogOwnerNameCn)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主英文名：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.dogOwnerNameEn)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主会员号：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.dogOwnerMemberCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">FCI代码：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.fciCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				${fns:getDictLabel(showResults.dogGender, 'dog_gender', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">年龄组别：</label>
			<div class="controls">
				${fns:getDictLabel(showResults.ageGroup, 'show_age_group', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬展编号：</label>
			<div class="controls">.
				${fns:escapeHtml(showResults.showCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">裁判：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.referee)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">活动区域：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.raceLap)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">修改说明：</label>
			<div class="controls">
				${fns:escapeHtml(showResults.remarks)}
			</div>
		</div>
<%-- 		<div class="control-group">
			<label class="control-label">犬只信息表主键：</label>
			<div class="controls">
				<form:input path="dogId" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">其他证书号：</label>
			<div class="controls">
				<form:input path="otherCertified" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种组：</label>
			<div class="controls">
				<form:input path="dogBreedGroup" htmlEscape="false" maxlength="10" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">WB项成绩：</label>
			<div class="controls">
				<form:input path="resultWb" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div> --%>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>