<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
<title>犬展酒店管理</title>
<meta name="decorator" content="default" />
<script type="text/javascript">
		var info = '${showHotel.hotelInfo}';
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
<!--引入wangEditor.css-->
<link rel="stylesheet" type="text/css" href="${ctxStatic }/wangEditor3/wangEditor.min.css">
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/show/showHotel/">犬展酒店列表</a></li>
		<li class="active"><a
			href="${ctx}/show/showHotel/form?id=${showHotel.id}">犬展酒店<shiro:hasPermission
					name="show:showHotel:edit">${not empty showHotel.id?'修改':'添加'}</shiro:hasPermission>
				<shiro:lacksPermission name="show:showHotel:edit">查看</shiro:lacksPermission></a></li>
	</ul>
	<br />
	<form:form id="inputForm" modelAttribute="showHotel"
		action="${ctx}/show/showHotel/save" method="post"
		class="form-horizontal">
		<form:hidden path="id" />
		<sys:message content="${message}" />
		<div class="control-group">
			<label class="control-label">酒店电话：</label>
			<div class="controls">
				<form:input path="hotelPhone" htmlEscape="false" maxlength="50"
					class="input-xlarge " />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">酒店地址：</label>
			<div class="controls">
				<form:input path="hotelAddress" htmlEscape="false"
					class="input-xlarge " />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">酒店名称：</label>
			<div class="controls">
				<form:input path="hotelName" htmlEscape="false" maxlength="100"
					class="input-xlarge " />
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">酒店介绍：</label>
			<div class="controls">
				<div id="editor"></div>
				<form:textarea htmlEscape="true" path="hotelInfo"
					style="height:400px;display:none;" />
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4"
					class="input-xxlarge " />
			</div>
		</div>

		<div class="form-actions">
			<shiro:hasPermission name="show:showHotel:edit">
				<input id="btnSubmit" class="btn btn-primary" type="submit"
					value="保 存" />&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回"
				onclick="history.go(-1)" />
		</div>
	</form:form>
	<!--引入jquery和wangEditor.js-->
	<!--注意：javascript必须放在body最后，否则可能会出现问题-->
	<script type="text/javascript" src="${ctxStatic }/wangEditor3/wangEditor.min.js"></script>
	<script type="text/javascript" src="${ctxStatic }/bundle/lrz.all.bundle.js"></script>
	<script type="text/javascript">
		var E = window.wangEditor;
		var editor = new E('#editor');
		var hotelInfo = $("#hotelInfo");
		editor.customConfig.onchange = function(html) {
			// 监控变化，同步更新到 textarea
			hotelInfo.val(html)
		}
		editor.customConfig.customUploadImg = function (resultFiles, insertImgFn) {
			console.log("size1:" + resultFiles[0].size);
	        lrz(resultFiles[0])
	            .then(function (rst) {
	                console.log("rst:" + rst.file);
	                console.log("size2:" + rst.file.size);
	                var formData = new FormData();
	                formData.append("editorImg", rst.file);
	                $.ajax({
	                    url: "${ctx}/sys/file/editorUploadJson",
	                    type: "POST",
	                    data: formData,
	                    contentType: false,
	                    processData: false,
	                    success: function (data) {
	                        insertImgFn(data.url)
	                    },
	                    error: function () {
	                        alert("上传失败！");
	                    }
	                });
	            })
	            .catch(function (err) {
	                console.log(rst);
	            })
	            .always(function () {
	                console.log(rst);
	            });
		};
		
		editor.customConfig.uploadImgHooks = {
			// 如果服务器端返回的不是 {errno:0, data: [...]} 这种格式，可使用该配置
			customInsert : function(insertImg, result, editor) {
				var url = result.url;
				insertImg(url);
			}
		}
		editor.create();
		editor.txt.html(info);
		hotelInfo.val(editor.txt.html());
	</script>
</body>
</html>